## EvalEntity

Evaluates an expression using a subCube or set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |subcube-set-expression |one | |
| |expression |one | |



### Return

```
numeric-value
```



### Description

The eval function with the second argument being not evaluated as a scalar value.



### Since Version

8.3


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### evalEntity(member-set,member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
SELECT
    [Measures].[Amount] ON 0
    evalEntity( [Geography].[Geo].[Europe], NonEmpty( [Geography].[Geo].[City].members, [Measures].[Amount] )) ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td>1</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td>128</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td>56</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td>64</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
   [Measures].[Amount] ON 0
   NonEmpty( Descendants( [Geography].[Geo].[Europe], [Geography].[Geo].[City]), [Measures].[Amount] ) ON 1
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Eval](Eval.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
