## Eval

Evaluates a scalar expression using a subCube or set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |subcube-set-expression |one | |
| |numeric-expression |one | |



### Return

```
numeric-value
```



### Description

Evaluates the numeric (i.e., scalar) expression using only the data defined by the subCube or set.

<pre>
Eval( SubCubeComplement( [Geography].[Switzerland] ), [Measure].[Amount] )
</pre>

When evaluating the expression, can be a calculated member, all tuples evaluations will be performed
on the defined subCube. They work similar to the security, you can not get back to the cube. You can check "Eval(SubCube,measure) - calculated measures" example.

This former behavior is different when using subcubes in a FILTERBY. In this scenario, calculated members
can overwrite hierarchies as we do for standard sets.

If the first parameter is a set, it will be converted to a SubCubeUnion of the set. Also, the currentMember of the hierarchy will be reset to the default members (since 6.8). So

<pre>
Eval( {[Geography].[Switzerland],[Geography].[France]}, [Measure].[Amount] )
</pre>

is evaluated as:

<pre>
Eval( {[Geography].[Switzerland],[Geography].[France]}, ([Geography].defaultMember,[Measure].[Amount]) )
</pre>

the default member is usually the "all" member.

Note, this reset is not done when a SubCube is used in the first parameter.

For dimensions that do not define a many-to-many relation, Eval is equivalent to the Aggregate function. We would advise using this function instead of the standard MDX function as it is more robust and works also on many-to-many relations. On top, you can use all the features of the SubCube function family.

SubCubeOthers is not supported.



### Since Version

5.1.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Eval(member-set,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a numeric value aggregated on the subcube defined by the set.

On the example we aggregate the default [Measures] for all the calendar months.

**Query**

```
WITH
    MEMBER [Measures].[All sales] AS Eval([Time].[Calendar].[Month].members, [Measures].[Amount])
SELECT
    [Measures].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">All sales</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[All sales] AS Sum([Time].[Calendar].[Month].members,[Measures].[Amount])
SELECT
    [Measures].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[All sales] AS Aggregate( [Time].[Calendar].[Month].members, [Measures].[Amount] )
SELECT
    [Measures].[All sales] ON COLUMNS,
    [Geography].[Geo].[Country].members ON ROWS
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Eval(SubCube,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a numeric value aggregated on the subcube defined by the set.

On the example we aggregate the default [Measures] for [Switzerland] and the [United States]

**Query**

```
WITH
    MEMBER [Measures].[US+CH] AS Eval( SubCubeUnion( [Geo].[Switzerland], [Geo].[United States]) , [Measures].[Amount])
SELECT
    [Measures].[US+CH] ON COLUMNS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">US+CH</td>
</tr>
<tr>
 <td>1016</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[US+CH] AS Sum( {[Geo].[Switzerland], [Geo].[United States]} , [Measures].[Amount])
SELECT
    [Measures].[US+CH] ON COLUMNS
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Eval(set,measure) - reset currentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns a numeric value aggregated on the subcube defined by the set and resets the [Geo] currentmember to [All].

On the example Eval behaves as Sum.

**Query**

```
WITH
    MEMBER [Measures].[US+CH] AS Eval( {[Geo].[Switzerland], [Geo].[United States]} , [Measures].[Amount])
SELECT
    [Measures].[US+CH] ON COLUMNS,
    [Geo].levels(2) ON ROWS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">US+CH</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>1016</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td>1016</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>1016</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td>1016</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>1016</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>1016</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>1016</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[US+CH] AS Eval( SubCubeUnion({[Geo].[Switzerland], [Geo].[United States]}) , ([Geo].defaultmember,[Measures].[Amount]) )
SELECT
    [Measures].[US+CH] ON COLUMNS,
    [Geo].levels(2) ON ROWS
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[US+CH] AS Sum( {[Geo].[Switzerland], [Geo].[United States]} , [Measures].[Amount])
SELECT
    [Measures].[US+CH] ON COLUMNS,
    [Geo].levels(2) ON ROWS
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Eval(subCube,measure) - reset currentMember II

</div>

<div class="ic3-mdx-example-body" style="display:none">

The same example as before but using a SubCubeUnion that does NOT reset the currentmember of the [Geo] dimension.

In this example, when evaluating [Amount] the current member of the [Geo] dimension will be the one defined by the axis.

**Query**

```
WITH
    MEMBER [Measures].[US+CH] AS Eval( SubCubeUnion({[Geo].[Switzerland], [Geo].[United States]}) , [Measures].[Amount])
SELECT
    [Measures].[US+CH] ON COLUMNS,
    [Geo].levels(2) ON ROWS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">US+CH</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mexico</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Venezuela</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td></td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[US+CH] AS IIF( [Geo].currentmember is [Geo].[Switzerland] OR [Geo].currentmember is [Geo].[United States],[Amount], NULL )
SELECT
    [Measures].[US+CH] ON COLUMNS,
    [Geo].levels(2) ON ROWS
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Eval(SubCube,measure) - calculated measures

</div>

<div class="ic3-mdx-example-body" style="display:none">

The subcube applies to all calculation done during a calculated measure evaluation.

Note that Spain is empty even though it is explicitly added.

**Query**

```
WITH
    MEMBER [Measures].[Amount + Spain] AS  [Measures].[Amount] + ([Geo].[Spain],[Measures].[Amount])
    MEMBER [Measures].[US+CH] AS Eval( SubCubeUnion({[Geo].[Switzerland], [Geo].[United States]}), [Measures].[Amount + Spain] )
SELECT
    {[Measures].[US+CH],[Measures].[Amount]} ON COLUMNS,
    {[Geo].[All Regions],[Geo].[Switzerland], [Geo].[United States],[Geo].[Spain]} ON ROWS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">US+CH</td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
 <td>1016</td>
 <td>1023</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248</td>
 <td>248</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td></td>
 <td>3</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[US+CH] AS IIF([Geo].currentmember.isAll,
                                    sum({[Geo].[Switzerland], [Geo].[United States]},[Measures].[Amount])
                                 ,
                                    IIF([Geo].currentmember is [Geo].[Spain],
                                      NULL
                                    ,
                                      [Measures].[Amount]
                                    )
                                 )
SELECT
    {[Measures].[US+CH],[Measures].[Amount]} ON COLUMNS,
    {[Geo].[All Regions],[Geo].[Switzerland], [Geo].[United States],[Geo].[Spain]} ON ROWS
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Eval(SubCube,measure) - nested

</div>

<div class="ic3-mdx-example-body" style="display:none">

It is possible to have nested subcube, each filter will reduce the size of the resulting subCube.

**Query**

```
WITH
    MEMBER [Measures].[Personal] AS Eval( {[Product].[Prod].[icCube].[Personal]} , [Measures].[Amount] )
    MEMBER [Measures].[US+CH Personal] AS Eval( {[Geo].[Europe], [Geo].[United States]} , [Measures].[Personal] )
SELECT
    [Measures].[US+CH Personal] ON COLUMNS
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">US+CH Personal</td>
</tr>
<tr>
 <td>15</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[US+CH Personal] AS Sum( {[Geo].[Europe], [Geo].[United States]} , ([Product].[Prod].[icCube].[Personal],[Measures].[Amount]) )
SELECT
    [Measures].[US+CH Personal] ON COLUMNS
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[EvalEntity](EvalEntity.md)

[SubCubeComplement](SubCubeComplement.md)

[SubCubeIntersect](SubCubeIntersect.md)

[SubCubeMinus](SubCubeMinus.md)

[SubCubeSymDifference](SubCubeSymDifference.md)

[SubCubeUnion](SubCubeUnion.md)

[FilterBy](FilterBy.md)

[Aggregate](Aggregate.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
