## DrilldownMemberBottom

Drills down members from the first specified set that are present in the second specified set limiting the number of items in the resulting set to the specified count parameter.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set-1 |set-expression | | |
|set-2 |set-expression | | |
|count |numeric-expression | | |
|measure |numeric-expression |zero-one | |
| |RECURSIVE |zero-one | |



### Return

```
set
```



### Description

The function drills down specified members from the first set (if they are present in the second set).

The number of returned drilled down members will be limited to the count parameter. Only count members from the top (i.e., that have the lowest value for the measure) will be appended to the result set.

The optional measure will be applied while sorting members; the default measures is used otherwise.

The optional RECURSIVE flag can be used : in such case the function continues recursively to drill down members.

This function can be used with tuple sets as well.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMemberBottom(member-set,member-set,numeric,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We're drilling down the icCube product to select the three licenses (sorted in ascending order) with the less sales.

**Query**

```
SELECT
    DrilldownMemberBottom(
        { [Product].[Prod].[icCube] },
        { [Product].[Prod].[icCube] },
        3,
        [Measures].[Amount]
    ) ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Europe]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">icCube</td>
  <td class="ic3-mdx-result-cell-header">Startup</td>
  <td class="ic3-mdx-result-cell-header">Personal</td>
  <td class="ic3-mdx-result-cell-header">Partnership</td>
</tr>
<tr>
 <td>255</td>
 <td></td>
 <td>15</td>
 <td>96</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    Union(
        [Product].[Prod].[icCube],
        Head( Order( [Product].[Prod].[icCube].Children, [Measures].[Amount], BASC), 3)
    ) ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Europe]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMemberBottom(member-set,member-set,numeric,measure,RECURSIVE)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We're recursively expanding the whole Europe, sorting in ascending order its countries and then for each country sorting in ascending order their cities.

**Query**

```
DrilldownMemberBottom(
    { [Geography].[Geo].[Europe] },
    { [Geography].[Geo].Members },
    1024,
    [Measures].[Amount],
    RECURSIVE
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[City].[Lausanne], 
  [Geography].[Geo].[City].[Zurich], 
  [Geography].[Geo].[City].[Geneva]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Union(
    [Geography].[Geo].[Europe],
    -- for each country
    Generate( Order( [Geography].[Geo].[Europe].Children, [Measures].[Amount], BASC),
              -- the list of cities
              Union( [Geography].[Geo].currentMember, Order( [Geography].[Geo].currentMember.Children, [Measures].[Amount], BASC ))
    )
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMemberBottom(tuple-set,member-set,numeric,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Drilldown is not limited to member sets.

We're drilling down (for the year 2010) the icCube product to select the three licenses (sorted in ascending order) with the less sales.

**Query**

```
SELECT
    DrilldownMemberBottom(
        { ( [Time].[Calendar].[2010], [Product].[Prod].[icCube] ) },
        { [Product].[Prod].[icCube] },
        3,
        [Measures].[Amount]
    ) ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Europe]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
  <td class="ic3-mdx-result-cell-header">2010</td>
</tr>
<tr>
  <td class="ic3-mdx-result-cell-header">icCube</td>
  <td class="ic3-mdx-result-cell-header">Startup</td>
  <td class="ic3-mdx-result-cell-header">Personal</td>
  <td class="ic3-mdx-result-cell-header">Partnership</td>
</tr>
<tr>
 <td>255</td>
 <td></td>
 <td>15</td>
 <td>96</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    Union(
        { ( [Time].[Calendar].[2010], [Product].[Prod].[icCube] ) },
        Head( Order( Crossjoin( [Time].[Calendar].[2010], [Product].[Prod].[icCube].Children ), [Measures].[Amount], BASC), 3)
    ) ON 0
FROM
    [Sales]
WHERE
    [Geography].[Geo].[Europe]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMemberBottom({},member-set,numeric,measure), DrilldownMemberBottom(NULL,member-set,numeric,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We pass a null/empty set and expect an empty set as result.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrilldownMemberBottom( {}, { [Geography].[Geo].[Europe] }, 1 )
```


**Assertion : MDX Equals**

```
DrilldownMemberBottom( NULL, { [Geography].[Geo].[Europe] }, 1 )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMemberBottom(member-set,{},numeric,measure), DrilldownMemberBottom(member-set,NULL,numeric,measure)

</div>

<div class="ic3-mdx-example-body" style="display:none">

No drilldown is performed : the first set is returned.

**Query**

```
{ [Geography].[Geo].[Europe],[Geography].[Geo].[America] }
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrilldownMemberBottom( { [Geography].[Geo].[Europe], [Geography].[Geo].[America] }, {}, 1 )
```


**Assertion : MDX Equals**

```
DrilldownMemberBottom( { [Geography].[Geo].[Europe], [Geography].[Geo].[America]}, NULL, 1 )
```


 
</div>

                                                                         

### See Also


[DrilldownLevel](DrilldownLevel.md)

[DrilldownLevelBottom](DrilldownLevelBottom.md)

[DrilldownLevelTop](DrilldownLevelTop.md)

[DrilldownMember](DrilldownMember.md)

[DrilldownMemberTop](DrilldownMemberTop.md)

[DrillUpLevel](DrillUpLevel.md)

[DrillUpMember](DrillUpMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
