## DrilldownMember

Drills down the members in a specified set that are present in a second specified set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set-1 |set-expression | | |
|set-2 |set-expression | | |
| |RECURSIVE | | |



### Return

```
set
```



### Description

The function takes two sets as parameters and constructs a new set from the first set including children of the elements from the second set that are present in the first set.

The optional RECURSIVE flag can be used : in such case the function continues recursively to drill down members.

This function can be used with tuple sets as well.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMember(member,member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We're drilling down the first child of Europe children; i.e., the children of that first child are inserted within the Europe children set whose hierarchical order is preserved.

**Query**

```
DrilldownMember(
    [Geography].[Geo].[Europe].Children,
    { [Geography].[Geo].[Europe].FirstChild }
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Union(
    [Geography].[Geo].[Europe].FirstChild,
    [Geography].[Geo].[Europe].FirstChild.Children,
    SubSet( [Geography].[Geo].[Europe].Children, 1 )
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMember(member,member-set,RECURSIVE)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We are expanding the whole Geo hierarchy.

**Query**

```
DrilldownMember (
    [Geography].[Geo].[All Regions],
    [Geography].[Geo].Members,
    RECURSIVE
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions], 
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[Country].[Venezuela], 
  [Geography].[Geo].[City].[Caracas], 
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[City].[Geneva], 
  [Geography].[Geo].[City].[Lausanne], 
  [Geography].[Geo].[City].[Zurich]
}</pre></td></tr></table>


**Assertion : Cell Equals**

```
[Geography].[Geo].Members
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMember(tuple-set,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

DrilldownMember is not limited to member sets.

We're drilling down the first child of Europe (i.e., the children of that first child are inserted within the Europe children set whose hierarchical order is preserved). The [2010] member of the tuples remains unchanged.

**Query**

```
DrilldownMember(
    Crossjoin( [Time].[Calendar].[2010], [Geography].[Geo].[Europe].Children ),
    [Geography].[Geo].[Europe].FirstChild
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[France] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[City].[Paris] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[Spain] ), 
  ( [Time].[Calendar].[Year].[2010], [Geography].[Geo].[Country].[Switzerland] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Crossjoin( [Time].[Calendar].[2010],
            Union(
                [Geography].[Geo].[Europe].FirstChild,
                [Geography].[Geo].[Europe].FirstChild.Children,
                SubSet( [Geography].[Geo].[Europe].Children, 1 )
            )
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMember(member-set,member) : parent-child specified

</div>

<div class="ic3-mdx-example-body" style="display:none">

A member will not get drilled down into if it is immediately followed by one of its children.

In this example, quarters of the year 2010 are not added because [Q2 2010] (as a child of 2010) is already present.

**Query**

```
DrilldownMember(
    { [Time].[2010], [Time].[Q2 2010] },
    [Time].[2010]
)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Year].[2010], 
  [Time].[Calendar].[Quarter].[Q2 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Time].[2010], [Time].[Q2 2010] }
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMember({},member-set), DrilldownMember(NULL,member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

We pass a null/empty set and expect an empty set as result.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrilldownMember( {}, { [Geography].[Geo].[Europe] } )
```


**Assertion : MDX Equals**

```
DrilldownMember( NULL, { [Geography].[Geo].[Europe] } )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### DrilldownMember(member-set,{}), DrilldownMember(member-set,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

No drilldown is performed : the first set is returned.

**Query**

```
{ [Geography].[Geo].[Europe],[Geography].[Geo].[America] }
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrilldownMember( { [Geography].[Geo].[Europe], [Geography].[Geo].[America] }, {} )
```


**Assertion : MDX Equals**

```
DrilldownMember( { [Geography].[Geo].[Europe], [Geography].[Geo].[America]}, NULL )
```


 
</div>

                                                                         

### See Also


[DrilldownLevel](DrilldownLevel.md)

[DrilldownLevelBottom](DrilldownLevelBottom.md)

[DrilldownLevelTop](DrilldownLevelTop.md)

[DrilldownMemberBottom](DrilldownMemberBottom.md)

[DrilldownMemberTop](DrilldownMemberTop.md)

[DrillUpLevel](DrillUpLevel.md)

[DrillUpMember](DrillUpMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
