## DrilldownLevel

Drills down one level members from the specified set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression | | |
|level |level-numeric-expression |zero-one | |
|index |numeric-expression |zero-one | |



### Return

```
set
```



### Description

The function drills down members from the specified set one level below; it takes one of two optional parameters: level or index.

If level was specified only the members from the set for this level will be drilled down.

The index parameter (zero-base) can be used when DrilldownLevel applies to a set of tuples, instead of a set of members. The index tells which member (or hierarchy) of the tuples should be used to perform the drilled down.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### No level / no index expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

We drill down a level for the [Spain] and [France] members. In result we have hierarchized members [Spain] and [France] with their children.

**Query**

```
DrilldownLevel({[Geography].[Geo].[Spain],[Geography].[Geo].[France]})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{
[Geography].[Geo].[Spain],
[Geography].[Geo].[Spain].children,
[Geography].[Geo].[France],
[Geography].[Geo].[France].children
}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Level expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

We drill down a level for the [Spain] and [Europe] members. Since we specify [Country] as the level for the drill down we will get hierarchized members [Spain] with its children and [Europe] only (continent level).

**Query**

```
DrilldownLevel( { [Geography].[Geo].[Europe], [Geography].[Geo].[Spain] }, [Geography].[Geo].[Country] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{
[Geography].[Geo].[Europe],
[Geography].[Geo].[Spain],
[Geography].[Geo].[Spain].children
}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Level expression - no member/hierarchy available

</div>

<div class="ic3-mdx-example-body" style="display:none">

There is no member at specified level (i.e., [City]) in the set; so no drilldown is performed and the set itself is returned.

**Query**

```
DrilldownLevel( { [Geography].[Geo].[Europe], [Geography].[Geo].[Spain] }, [Geography].[Geo].[City] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe], 
  [Geography].[Geo].[Country].[Spain]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Geography].[Geo].[Europe], [Geography].[Geo].[Spain] }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Index expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

We creates a set of tuples from [Continent]s and [Years]. Specifying 1 as index, we are drilling down for the levels of the hierarchy with the index 1 which is [Time]; quarters are returned.

**Query**

```
DrilldownLevel( { ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010] ) }, , 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Quarter].[Q1 2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Quarter].[Q2 2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Quarter].[Q3 2010] ), 
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Quarter].[Q4 2010] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Union(
    { ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010] ) },
    CrossJoin( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010].Children )
)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Index expression - no member/hierarchy available

</div>

<div class="ic3-mdx-example-body" style="display:none">

The index expression does not reference any valid hierarchy; so no drilldown is performed and the set itself is returned.

**Query**

```
DrilldownLevel( { ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010] ) }, , 10)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ ( [Geography].[Geo].[Continent].[America], [Time].[Calendar].[Year].[2010] ) }
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Invalid level expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

There is no member from hierarchy of the specified level expression.

**Query**

```
SELECT DrilldownLevel( { [Geography].[Geo].[Europe], [Geography].[Geo].[Spain] }, [Time].[Calendar].[Year] ) ON 0 FROM [Sales]
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DRILLDOWN_INVALID_HIERARCHY](icCubeError.md#olap_drilldown_invalid_hierarchy)</td></tr><tr><td>Error Message</td><td>

DrilldownLevel() : the hierarchy '[Time].[Calendar]' is not available in the set</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Invalid index expression

</div>

<div class="ic3-mdx-example-body" style="display:none">

The index does not reference any hierarchy.

**Query**

```
DrilldownLevel( [Geography].[Geo].[Continent].members, , -1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_OUT_OF_RANGE](icCubeError.md#olap_out_of_range)</td></tr><tr><td>Error Message</td><td>

DrilldownLevel() : the hierarchy/member index value '-1' is out of range (expected range:'>= 0')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Null / empty set

</div>

<div class="ic3-mdx-example-body" style="display:none">

We pass null/empty set and expect an empty set as result.

**Query**

```
{}
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
DrilldownLevel({})
```


**Assertion : MDX Equals**

```
DrilldownLevel(NULL)
```


 
</div>

                                                                         

### See Also


[DrilldownLevelBottom](DrilldownLevelBottom.md)

[DrilldownLevelTop](DrilldownLevelTop.md)

[DrilldownMember](DrilldownMember.md)

[DrilldownMemberBottom](DrilldownMemberBottom.md)

[DrilldownMemberTop](DrilldownMemberTop.md)

[DrillUpLevel](DrillUpLevel.md)

[DrillUpMember](DrillUpMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
