## Distinct

Returns a set removing all duplicated members.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression | | |



### Return

```
numeric-value
```



### Description

Returns a set removing duplicated members from the parameter set.

{A,B,A,C,A} -> {A,B,C}

This function keeps the order of the original set.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Distinct(set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the distinct members of the set.

In the example, the two distinct members [Paris] and [Madrid].

**Query**

```
Distinct({[Geography].[Geo].[Paris], [Geography].[Geo].[Madrid], [Geography].[Geo].[Paris]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[City].[Madrid]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Paris], [Geography].[Geo].[Madrid]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Distinct(set) - NULL and empty set

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set if applied to a NULL entity or empty set.

**Query**

```
SELECT
    Distinct({}) ON 0
FROM
    Sales
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
    Distinct(null) ON 0
FROM
    Sales
```


**Assertion : MDX Equals**

```
SELECT
    {} ON 0
FROM
    Sales
```


 
</div>

                                                                         

### See Also


[Count](Count.md)

[DistinctCount](DistinctCount.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
