## Dimensions

Lookup a hierarchy by name or ordinal.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |string-numeric-expression |one | |



### Return

```
level
```



### Description

Lookup a hierarchy by name or ordinal. Note that the first dimension is [Measures] (an ordinal of 0).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimensions( 0 )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first [Measures] hierarchy.

**Query**

```
WITH MEMBER [hierarchy-name] AS Dimensions(0).uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">hierarchy-name</td>
</tr>
<tr>
 <td>[Measures]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [hierarchy-name] AS [Measures].[Measures].uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimensions( name )

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first [Geography].[Geo] hierarchy.

**Query**

```
WITH MEMBER [hierarchy-name] AS Dimensions( "[Geography].[Geo]" ).uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">hierarchy-name</td>
</tr>
<tr>
 <td>[Geography].[Geo]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH MEMBER [hierarchy-name] AS [Geography].[Geo].uniqueName
SELECT [hierarchy-name] ON 0 FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[Levels](Levels.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
