## Descendants

Returns descendants for the specified member at specified level or distance with different conditions.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|member(s) |set-member-expression |one | |
|level (or distance) |level-numeric-expression |zero-one | |
|option |SELF-AFTER-BEFORE-BEFORE_AND_AFTER-SELF_AND_AFTER-SELF_AND_BEFORE-SELF_BEFORE_AFTER-LEAVES |zero-one | |



### Return

```
set
```



### Description

Descendants function returns:

1) descendants for the specified member at the specified level or distance.
2) descendants for the set members at the specified level or distance.

Optional flags may be used with this function:

1) SELF - returns only members from the specified level or at specified distance.
2) AFTER - returns only members after the specified level or after specified distance.
3) BEFORE - returns only members between the specified member and specified level or distance.
4) BEFORE_AND_AFTER - returns members between the specified member and specified level or distance and members after specified level or distance.
5) SELF_AND_AFTER - returns members after the specified level or after specified distance and specified member itself.
6) SELF_AND_BEFORE - returns members between the specified member and specified level or distance and specified member itself.
7) SELF_BEFORE_AFTER - returns all members from all levels after the level of the specified member including member itself.
8) LEAVES - returns only leaves members between specified member and specified level or distance. Members of the specified level are considered as leaves. If no level is specified returns all the leaves below the member.

If no level or distance is specified, the default value for the level used by the function is determined by calling the Level function for the specified member or by calling the Level function for each member of the specified set.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all children of the members, in the example [America] children.

**Query**

```
Descendants([Geography].[Geo].[America],1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country])
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[America].children
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(set,1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all children of the set members, in the example [Europe] and [America] children.

**Query**

```
Descendants({[Geography].[Geo].[Europe],[Geography].[Geo].[America]},1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Europe].children + [Geography].[Geo].[America].children
```


**Assertion : MDX Equals**

```
Descendants({[Geography].[Geo].[Europe],[Geography].[Geo].[America]},[Geography].[Geo].[Country])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,2)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the next two levels descendants of the member, in the example [America] children and grandchildren.

**Query**

```
Descendants([Geography].[Geo].[America],2)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[City].[Caracas]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[City])
```


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],55)
```


**Assertion : MDX Equals**

```
Generate( [Geography].[Geo].[America].children, [Geography].[Geo].CurrentMember.children)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants at the given level, in our example [America] descendants which are at level [Country].

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],1)
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[America].children
```


**Assertion : MDX Equals**

```
Filter([Geography].[Geo].[Country].members, [Geography].[Geo].CurrentMember.Parent IS [Geography].[Geo].[America])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants of the members, including itself.

**Query**

```
Descendants([Geography].[Geo].[America])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[Country].[Venezuela], 
  [Geography].[Geo].[City].[Caracas]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Hierarchize({[Geography].[Geo].[America] } + Descendants([Geography].[Geo].[America],1) + Descendants([Geography].[Geo].[America],2))
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level,BEFORE)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants before the given level including itself, in our example [America] and it's children.

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[City],BEFORE)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America],[Geography].[Geo].[America].children}
```


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],2,BEFORE)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level,AFTER)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants after the given level, in our example [America] descendants at [Country] level.

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country],AFTER)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[City].[Caracas]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],2)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level,SELF)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants at the given level, in our example [America] children. It is the default flag.

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country],SELF)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country])
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[America].children
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level,BEFORE_AND_AFTER)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants before and after the given level; in our example [America] descendants without members at [Country] level.

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country],BEFORE_AND_AFTER)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[City].[Caracas]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America]} + Descendants([Geography].[Geo].[America],2)
```


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America]) - Descendants([Geography].[Geo].[America],1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level,SELF_AND_BEFORE)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants before and at the given level; in our example [America] and his children.

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country],SELF_AND_BEFORE)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America], 
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[America]} + {[Geography].[Geo].[America].children}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level,SELF_AND_AFTER)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all descendants at and after the given level, in our example [America] descendants (without self)

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country],SELF_AND_AFTER)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[Country].[Venezuela], 
  [Geography].[Geo].[City].[Caracas]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Hierarchize( Descendants([Geography].[Geo].[America],1) + Descendants([Geography].[Geo].[America],2) )
```


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America]) - {[Geography].[Geo].[America]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,level,LEAVES)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns all leaves between the member and the specified level; member in the specified level are considered as leaves.

**Query**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country],LEAVES)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[Canada], 
  [Geography].[Geo].[Country].[Mexico], 
  [Geography].[Geo].[Country].[United States], 
  [Geography].[Geo].[Country].[Venezuela]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[Country],SELF)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,,LEAVES)

</div>

<div class="ic3-mdx-example-body" style="display:none">

When no level is specified, returns all leaves below the member; in this example all descendant of America in the City level.

**Query**

```
Descendants([Geography].[Geo].[America],,LEAVES)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[City].[Mexico], 
  [Geography].[Geo].[City].[Los Angeles], 
  [Geography].[Geo].[City].[New York], 
  [Geography].[Geo].[City].[San Francisco], 
  [Geography].[Geo].[City].[Caracas]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America],[Geography].[Geo].[City], SELF)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,,option)

</div>

<div class="ic3-mdx-example-body" style="display:none">

As no level or distance is specified, the default value for the level used by the function is determined by calling the Level function for the specified member.

**Query**

```
Descendants([Geography].[Geo].[Canada], , AFTER)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[Canada], [Geography].[Geo].[Canada].level, AFTER)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(set,,option)

</div>

<div class="ic3-mdx-example-body" style="display:none">

As no level or distance is specified, the default value for the level used by the function is determined by calling the Level function for each member of the specified set.

**Query**

```
Descendants( { [Geography].[Geo].[Canada], [Geography].[Geo].[Europe] }, , AFTER)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Quebec], 
  [Geography].[Geo].[City].[Toronto], 
  [Geography].[Geo].[Country].[France], 
  [Geography].[Geo].[City].[Paris], 
  [Geography].[Geo].[Country].[Spain], 
  [Geography].[Geo].[City].[Barcelona], 
  [Geography].[Geo].[City].[Madrid], 
  [Geography].[Geo].[City].[Valencia], 
  [Geography].[Geo].[Country].[Switzerland], 
  [Geography].[Geo].[City].[Geneva], 
  [Geography].[Geo].[City].[Lausanne], 
  [Geography].[Geo].[City].[Zurich]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Union(
Descendants( [Geography].[Geo].[Canada], [Geography].[Geo].[Canada].level, AFTER ),
Descendants( [Geography].[Geo].[Europe], [Geography].[Geo].[Europe].level, AFTER )
)
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(member,0)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member itself when 0 is used as level; in our example [America].

**Query**

```
Descendants([Geography].[Geo].[America],0)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[America]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Descendants([Geography].[Geo].[America], [Geography].[Geo].[America].level)
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[America]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(leaf member,1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member itself; in our example [Lausanne].

**Query**

```
Descendants([Geography].[Geo].[Lausanne],1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Lausanne]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Lausanne]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(wrong level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid level.

**Query**

```
Descendants([Geography].[Geo].[Lausanne],[Product].[Prod].[Company])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DESCENDANTS_INVALID_LEVEL](icCubeError.md#olap_descendants_invalid_level)</td></tr><tr><td>Error Message</td><td>

Descendants() : level '[Product].[Prod].[Company]' is not of the expected hierarchy '[Geography].[Geo].[City].&[LAUSANNE]'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### NULL's descendants

</div>

<div class="ic3-mdx-example-body" style="display:none">

NULL has no descendant.

**Query**

```
Descendants( NULL )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Descendants(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]))
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Descendants() : argument (0) type mismatch: expected:'set(member)', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Descendants({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Descendants() : argument (0) type mismatch: expected:'set(member)', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Descendants(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Descendants("hello")
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Descendants() : argument (0) type mismatch: expected:'set', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Ascendants](Ascendants.md)

[Expand](Expand.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
