## CurrentCellValue

Returns the current cell value



### Return

```
value
```



### Description

Returns the current cell value and should be used in the context of a cell property.

For example, we can create a cell formatter that depends on the value of the cell:

<pre> FORMAT_STRING = iif( isNaN( currentCellValue() ),
'invalid number',
iif( isInfinity( currentCellValue() ), 'j:infinite number', 'j:%f' )
) </pre>



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CurrentCellValue()

</div>

<div class="ic3-mdx-example-body" style="display:none">

In our example we change the display value of a cell if it's value is equal to 2.

**Query**

```
WITH
    MEMBER [Measures].[x] AS  2, FORMAT_STRING= iif( currentCellValue() = 2, '(#)', '#' )
    MEMBER [Measures].[y] AS  4, FORMAT_STRING= iif( currentCellValue() = 2, '(#)', '#' )
SELECT
    { [Measures].[x], [Measures].[y] } ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">x</td>
  <td class="ic3-mdx-result-cell-header">y</td>
</tr>
<tr>
 <td>(2)</td>
 <td>4</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[x] AS  2, FORMAT_STRING= '(#)'
    MEMBER [Measures].[y] AS  4, FORMAT_STRING= '#'
SELECT
    { [Measures].[x], [Measures].[y] } ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CurrentCellValue() - wrong context

</div>

<div class="ic3-mdx-example-body" style="display:none">

Calling CurrentCellValue() in a the context of a calculated measure will return NULL.

**Query**

```
WITH
    MEMBER [Measures].[Value] as currentCellValue() * 2
SELECT
    [Measures].[Value] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Value</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_CURRENT_CELL_VALUE_CONTEXT_ERROR)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_CURRENT_CELL_VALUE_CONTEXT_ERROR](icCubeError.md#olap_current_cell_value_context_error)<br>Error Message : CurrentCellValue() function cannot be called outside a cell property evaluation context</pre>


 
</div>

                                                                                                            

### See Also


[Current](Current.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
