## Current

Returns the current tuple or member (synonym of currentMember)


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |hierarchy-expression |zero-one | |



### Return

```
member
```



### Description

Allows to retrieve information about hierarchy members in the current context.

The context is defined as following:

1) the calculated member's tuple context ( e.g ( [Time].[2010], [Measures].[Year Diff.] ) )
2) the tuple being iterated (e.g., Sum,(), ...). Note Eval() function has no current tuple.
3) the cell tuples from the axes being evaluated.
4) the slicer content.
5) the default members.

Current member works also across hierarchies of the same dimension. If there is a unique member of the specified hierarchy that 'exists' on the current context.

If applied to a named set it will return the current member or tuple of the set.

Since icCube 4.8, this function returns a set of members if the tuple contains two members of the same hierarchy. This functionality needs the 'dimensionalityCheck' icCube property set to false.


Since version 8.2, current works across attribute hierarchies.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Current - default member

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the hierarchy is not defined in our MDX query, default member is taken as currentMember.

**Query**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].Current.Name
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Year's Name</td>
</tr>
<tr>
 <td>2010</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].DefaultMember.Name
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Current - slicer

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the hierarchy is defined in the slicer (aka. where clause), it is taken as currentMember.

In our example, [Time].[Calendar].Current is [Time].[Calendar].[Year].[2010]

**Query**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].Current.NAME
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Year].[2010]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Year's Name</td>
</tr>
<tr>
 <td>2010</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Year's Name] AS "2010"
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Current - auto-exists

</div>

<div class="ic3-mdx-example-body" style="display:none">

CurrentMember can also be used across hierarchies of the same dimension.

In our example, all descendants of [Geo].[Canada] result in a [Economy].[Canada] currentMember. Remember [Economy] hierarchy ends at [Country] level.

Note: MSAS 2008 matches auto-exists only on attributes hierarchies (aka. one level no base hierarchy).

**Query**

```
WITH
    MEMBER economy_unique_name as [Geography].[Economy].current.uniqueName
SELECT
     economy_unique_name on 0,
     Descendants([Geography].[Geo].[Canada])  on 1
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">economy_unique_name</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>[Geography].[Economy].[Country].&[CA]</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quebec</td>
 <td>[Geography].[Economy].[Country].&[CA]</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toronto</td>
 <td>[Geography].[Economy].[Country].&[CA]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER economy_unique_name as [Geography].[Economy].[Canada].uniqueName
SELECT
     economy_unique_name on 0,
     Descendants([Geography].[Geo].[Canada])  on 1
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Current - axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the hierarchy is defined in the axis, it is taken as currentMember.

In our example, [Time].[Calendar].Current is [Time].[Calendar].[Year].[2010]

**Query**

```
WITH
    MEMBER [Measures].[Q. Name] AS [Time].[Calendar].Current.Name
SELECT
    subset([Time].[Calendar].[2010].Children,0,2) ON 0
FROM
    [Sales]
WHERE
    [Measures].[Q. Name]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
</tr>
<tr>
 <td>Q1 2010</td>
 <td>Q2 2010</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Q1] AS [Time].[Calendar].[Q1 2010].Name
    MEMBER [Measures].[Q2] AS [Time].[Calendar].[Q2 2010].Name
SELECT
    {[Measures].[Q1],[Measures].[Q2]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.Current - iteration

</div>

<div class="ic3-mdx-example-body" style="display:none">

The Generate() iteration is defining the current member for the [Geography].[Geo] hierarchy.

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, [Geography].[Geo].current.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### (Same Hierarchy Tuple).Current - set

</div>

<div class="ic3-mdx-example-body" style="display:none">

When the tuple contains multiple members of the same hierarchy the current function will return a set.

**Query**

```
WITH
    MEMBER [MyMeasure] AS SetToStr([Geography].[Geo].current)
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">America</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>{[Geography].[Geo].[Continent].&[AMERICA],[Geography].[Geo].[Continent].&[EUROPE]}</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [MyMeasure] AS "{" + [Geography].[Geo].[Continent].[America].uniqueName +  ","+  [Geography].[Geo].[Continent].[Europe].uniqueName + "}"
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### (Same Hierarchy Tuple).Current(0) - nth member

</div>

<div class="ic3-mdx-example-body" style="display:none">

When the tuple contains multiple members of the same hierarchy the current(n) function will return the Nth member of the set.

**Query**

```
WITH
    MEMBER [MyMeasure] AS [Geography].[Geo].current(0).name
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">America</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>America</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [MyMeasure] AS [Geography].[Geo].[Continent].[America].name
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### as-named-set.CurrentMember - iteration

</div>

<div class="ic3-mdx-example-body" style="display:none">

CurrentMember can be applied to a named set being iterated as declared within a function parameter.

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, countries.CurrentMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.CurrentMember - iteration

</div>

<div class="ic3-mdx-example-body" style="display:none">

CurrentMember can be applied to a named set being iterated.

**Query**

```
WITH
    SET    [Countries] AS { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] }
    MEMBER [Measures].[Names] AS Generate( [Countries], countries.CurrentMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.CurrentMember - iteration - tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

CurrentMember can be applied to a tuple set (being equivalent to the Current() function).

**Query**

```
WITH
    SET    [MySet] AS { ( [Geography].[Geo].[New York], [Product].[icCube] ) }
    MEMBER [Measures].[Names] AS Generate( [MySet], TupleToStr( MySet.CurrentMember ), "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>([Geography].[Geo].[City].&[NEW YORK],[Product].[Prod].[Article].&[ICCUBE])</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "(" + [Geography].[Geo].[City].&[New York].uniqueName + "," + [Product].[Prod].[Article].&[icCube].uniqueName + ")"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### as-named-set.Current - member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of members) being iterated as declared within a function parameter.

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, countries.Current.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.Current - member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of members) being iterated.

**Query**

```
WITH
    SET    [Countries] AS { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] }
    MEMBER [Measures].[Names] AS Generate( [Countries], countries.Current.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.Current - tuple

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of tuples) being iterated.

**Query**

```
WITH
    SET    [MySet] AS { ( [Geography].[Geo].[New York], [Product].[icCube] ) }
    MEMBER [Measures].[Names] AS Generate( [MySet], TupleToStr( MySet.Current ), "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>([Geography].[Geo].[City].&[NEW YORK],[Product].[Prod].[Article].&[ICCUBE])</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "(" + [Geography].[Geo].[City].&[New York].uniqueName + "," + [Product].[Prod].[Article].&[icCube].uniqueName + ")"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### null.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
NULL.CurrentMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

CurrentMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).CurrentMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

CurrentMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
[Geography].[Geo].[Continent].CurrentMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

CurrentMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.CurrentMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

CurrentMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.CurrentMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

CurrentMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.CurrentMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
"hello".CurrentMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

CurrentMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[CurrentMember](CurrentMember.md)

[ContextMember](ContextMember.md)

[ContextMembers](ContextMembers.md)

[CurrentMember](CurrentMember.md)

[Exists](Exists.md)

[Same Hierarchy Tuple](Same%20Hierarchy%20Tuple.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
