## Count

Returns the number of elements in the specified set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression |one | |
| |EXCLUDEEMPTY-INCLUDEEMPTY |zero-one |INCLUDEEMPTY |



### Return

```
numeric-value
```



### Description

Returns the number of elements in the specified set.

INCLUDEEMPTY (default behavior) : empty cells are included in the count (using the measure in the current context).

EXCLUDEEMPTY : does not includes empty cells in the count (using the measure in the current context).

set-expression.Count : an alternate syntax that is equivalent to Count( set-expression, INCLUDEEMPTY )



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the number of items of the set.

In our example, we are counting the number of quarters of the year 2010.

**Query**

```
WITH
    MEMBER [Measures].[Quarter Count] AS Count( [Time].[Calendar].[2010].Children )
SELECT
    [Measures].[Quarter Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Quarter Count</td>
</tr>
<tr>
 <td>4</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Quarter Count] AS Count( [Time].[Calendar].[2010].Children, INCLUDEEMPTY )
SELECT
    [Measures].[Quarter Count] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Quarter Count] AS 4
SELECT
    [Measures].[Quarter Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(set,EXCLUDEEMPTY)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the number of none empty tuples of the set.

In our example, we are comparing Count(set,EXCLUDEEMPTY) with the equivalent Count(NonEmpty(set))

**Query**

```
WITH
    MEMBER [Geography].[Geo].[Count] AS Count( [Geography].[Geo].[City].Members , EXCLUDEEMPTY )
SELECT
    [Geography].[Geo].[Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Count</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Geography].[Geo].[Count] AS Count(NonEmpty( [Geography].[Geo].[City].Members ))
SELECT
    [Geography].[Geo].[Count] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(set,EXCLUDEEMPTY) - measures current member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Count is using the current member of the [Measures] when not specified.

In our example, we define a current measure (always not empty) to compare both EXCLUDEEMPTY and INCLUDEEMPTY versions.

**Query**

```
WITH
    MEMBER [Measures].[the-answer] AS 42, SOLVE_ORDER = 0
    MEMBER [Geography].[Geo].[City Count] AS Count( [Geography].[Geo].[City].Members, EXCLUDEEMPTY ), SOLVE_ORDER = 1
SELECT
    [Geography].[Geo].[City Count] ON 0
FROM
    [Sales]
WHERE
    [Measures].[the-answer]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">City Count</td>
</tr>
<tr>
 <td>14</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Geography].[Geo].[City Count] AS Count( [Geography].[Geo].[City].Members )
SELECT
    [Geography].[Geo].[City Count] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Count(set,EXCLUDEEMPTY) - recursive call

</div>

<div class="ic3-mdx-example-body" style="display:none">

As Count() is using the [Measures] current member (when not specified in the set tuples), you cannot define a calculated measure (as opposed to calculated member) without specifying explicitly the [Measures].

**Query**

```
WITH
    MEMBER [Measures].[City Count] AS Count( [Geography].[Geo].[City].Members, EXCLUDEEMPTY )
SELECT
    [Measures].[City Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">City Count</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_CALC_MEMBER_STACK_OVERFLOW)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_CALC_MEMBER_STACK_OVERFLOW](icCubeError.md#olap_calc_member_stack_overflow)<br>Error Message : Calculated member [Measures].[City Count] stack overflow (see icCube.calcMemberMaxEvaluationFrameStackSize XMLA property) detected at (City Count City Count)</pre>


 
</div>

                                                                         

### See Also


[DistinctCount](DistinctCount.md)

[NonEmpty](NonEmpty.md)

[Count(Dimensions)](Count(Dimensions).md)

[Count(Levels)](Count(Levels).md)

[Count(Level)](Count(Level).md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
