## Count(Dimensions)

Returns the number of hierarchies in a cube.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |dimensions-expression |one | |



### Return

```
numeric-value
```



### Description

Returns the number of hierarchies in a cube. Syntax: Dimensions.Count



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Dimensions.Count

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the number of hierarchies of the cube [Sales].

**Query**

```
WITH
    MEMBER [Measures].[Hierarchy Count] AS Dimensions.Count
SELECT
    [Measures].[Hierarchy Count] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Hierarchy Count</td>
</tr>
<tr>
 <td>11</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Hierarchy Count] AS Root().Count
SELECT
    [Measures].[Hierarchy Count] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Count(Levels)](Count(Levels).md)

[Count(Level)](Count(Level).md)

[Count](Count.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
