## ContextMember

Returns the context member of a hierarchy including the Subquery content


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |hierarchy-expression |zero-one | |



### Return

```
member
```



### Description

Allows to retrieve information about hierarchy members in the current context. This function is a slight modification from the 'standard' currentMember function.

The context is defined as following:

1) the calculated member's tuple context ( e.g ( [Time].[2010], [Measures].[Year Diff.] ) )
2) the tuple being iterated (e.g., Sum,(), ...). Note Eval() function has no current tuple.
3) the cell tuples from the axes being evaluated.
4) the slicer content.
5) the subSelect content.
6) the default members.

As a difference to the currentMember function, the contextMember will not work across hierarchies and will
use the subQuery definition.



### Since Version

6.5.1


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.contextMember - default member

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the hierarchy is not defined in our MDX query, default member is taken as contextMember.

**Query**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].contextMember.Name
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Year's Name</td>
</tr>
<tr>
 <td>2010</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].DefaultMember.Name
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.contextMember - slicer

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the hierarchy is defined in the slicer (aka. where clause), it is taken as contextMember.

In our example, [Time].[Calendar].contextMember is [Time].[Calendar].[Year].[2011]

**Query**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].contextMember.NAME
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
WHERE
    [Time].[Calendar].[Year].[2011]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Year's Name</td>
</tr>
<tr>
 <td>2011</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Year's Name] AS "2011"
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.contextMember - SubQuery

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the hierarchy is defined in the SubQuery (aka. subselect), it is taken as contextMember.

In our example, [Time].[Calendar].contextMember is [Time].[Calendar].[Year].[2010]

**Query**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].contextMember.NAME
SELECT
    [Measures].[Year's Name] ON 0
FROM
( Select [Time].[Calendar].[Year].[2010] on 0 from [Sales] )
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Year's Name</td>
</tr>
<tr>
 <td>2010</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Year's Name] AS "2010"
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
```


**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].contextMember.NAME
SELECT
    [Measures].[Year's Name] ON 0
FROM
    [Sales]
FILTERBY [Time].[Calendar].[Year].[2010]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.contextMember - auto-exists

</div>

<div class="ic3-mdx-example-body" style="display:none">

ContextMember does not work across hierarchies like currentMember

**Query**

```
WITH
    MEMBER economy_unique_name as [Geography].[Economy].contextMember.uniqueName
SELECT
     economy_unique_name on 0,
     Descendants([Geography].[Geo].[Canada])  on 1
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">economy_unique_name</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Canada</td>
 <td>[Geography].[Economy].[ALL]</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Quebec</td>
 <td>[Geography].[Economy].[ALL]</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Toronto</td>
 <td>[Geography].[Economy].[ALL]</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER economy_unique_name as [Geography].[Economy].defaultMember.uniqueName
SELECT
     economy_unique_name on 0,
     Descendants([Geography].[Geo].[Canada])  on 1
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.contextMember - axis

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the hierarchy is defined in the axis, it is taken as contextMember.

In our example, [Time].[Calendar].contextMember is [Time].[Calendar].[Year].[2010]

**Query**

```
WITH
    MEMBER [Measures].[Q. Name] AS [Time].[Calendar].contextMember.Name
SELECT
    subset([Time].[Calendar].[2010].Children,0,2) ON 0
FROM
    [Sales]
WHERE
    [Measures].[Q. Name]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Q1 2010</td>
  <td class="ic3-mdx-result-cell-header">Q2 2010</td>
</tr>
<tr>
 <td>Q1 2010</td>
 <td>Q2 2010</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Measures].[Q1] AS [Time].[Calendar].[Q1 2010].Name
    MEMBER [Measures].[Q2] AS [Time].[Calendar].[Q2 2010].Name
SELECT
    {[Measures].[Q1],[Measures].[Q2]} ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.contextMember - iteration

</div>

<div class="ic3-mdx-example-body" style="display:none">

The Generate() iteration is defining the contextMember member for the [Geography].[Geo] hierarchy.

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, [Geography].[Geo].contextMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### (Same Hierarchy Tuple).contextMember - set

</div>

<div class="ic3-mdx-example-body" style="display:none">

When the tuple contains multiple members of the same hierarchy the contextMember function will return a set.

**Query**

```
WITH
    MEMBER [MyMeasure] AS SetToStr([Geography].[Geo].contextMember)
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">America</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>{[Geography].[Geo].[Continent].&[AMERICA],[Geography].[Geo].[Continent].&[EUROPE]}</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [MyMeasure] AS "{" + [Geography].[Geo].[Continent].[America].uniqueName +  ","+  [Geography].[Geo].[Continent].[Europe].uniqueName + "}"
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### (Same Hierarchy Tuple).contextMember(0) - nth member

</div>

<div class="ic3-mdx-example-body" style="display:none">

When the tuple contains multiple members of the same hierarchy the contextMember(n) function will return the Nth member of the set.

**Query**

```
WITH
    MEMBER [MyMeasure] AS [Geography].[Geo].contextMember(0).name
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">America</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>America</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [MyMeasure] AS [Geography].[Geo].[Continent].[America].name
SELECT
    [Geography].[Geo].[Continent].[America] on 0,
    [Geography].[Geo].[Continent].[Europe] on 1
FROM [SALES]
WHERE [MyMeasure]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### as-named-set.contextMember - iteration

</div>

<div class="ic3-mdx-example-body" style="display:none">

contextMember can be applied to a named set being iterated as declared within a function parameter.

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, countries.contextMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.contextMember - iteration

</div>

<div class="ic3-mdx-example-body" style="display:none">

contextMember can be applied to a named set being iterated.

**Query**

```
WITH
    SET    [Countries] AS { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] }
    MEMBER [Measures].[Names] AS Generate( [Countries], countries.contextMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.contextMember - iteration - tuples

</div>

<div class="ic3-mdx-example-body" style="display:none">

contextMember can be applied to a tuple set (being equivalent to the contextMember() function).

**Query**

```
WITH
    SET    [MySet] AS { ( [Geography].[Geo].[New York], [Product].[icCube] ) }
    MEMBER [Measures].[Names] AS Generate( [MySet], TupleToStr( MySet.contextMember ), "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>([Geography].[Geo].[City].&[NEW YORK],[Product].[Prod].[Article].&[ICCUBE])</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "(" + [Geography].[Geo].[City].&[New York].uniqueName + "," + [Product].[Prod].[Article].&[icCube].uniqueName + ")"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### as-named-set.contextMember - member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of members) being iterated as declared within a function parameter.

**Query**

```
WITH
    MEMBER [Measures].[Names] AS Generate( { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] } AS countries, countries.contextMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.contextMember - member

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of members) being iterated.

**Query**

```
WITH
    SET    [Countries] AS { [Geography].[Geo].[Continent].[America], [Geography].[Geo].[Continent].[Europe] }
    MEMBER [Measures].[Names] AS Generate( [Countries], countries.contextMember.Name, "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>America-Europe</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "America-Europe"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### named-set.contextMember - tuple

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applied to a named set (of tuples) being iterated.

**Query**

```
WITH
    SET    [MySet] AS { ( [Geography].[Geo].[New York], [Product].[icCube] ) }
    MEMBER [Measures].[Names] AS Generate( [MySet], TupleToStr( MySet.contextMember ), "-" )
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Names</td>
</tr>
<tr>
 <td>([Geography].[Geo].[City].&[NEW YORK],[Product].[Prod].[Article].&[ICCUBE])</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Names] AS "(" + [Geography].[Geo].[City].&[New York].uniqueName + "," + [Product].[Prod].[Article].&[icCube].uniqueName + ")"
SELECT
    [Measures].[Names] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### hierarchy.contextMember - Error on multiple members

</div>

<div class="ic3-mdx-example-body" style="display:none">

If the context as more than one member for the parameter hierarchy it will return an error.

**Query**

```
WITH
    MEMBER [Measures].[Year's Name] AS [Time].[Calendar].contextMember.NAME
SELECT
    [Measures].[Year's Name] ON 0
FROM [Sales]
FILTERBY {[Time].[Calendar].[Year].[2010],[Time].[Calendar].[Year].[2011]}
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Year's Name</td>
</tr>
<tr>
 <td>#ERROR : (OLAP_CONTEXT_MEMBER_MULTIPLE_MEMBERS)</td>
</tr>
</table>
<pre>Error Code    : [OLAP_CONTEXT_MEMBER_MULTIPLE_MEMBERS](icCubeError.md#olap_context_member_multiple_members)<br>Error Message : Context returns multiple members, a single member or none is expected (you can use contextMembers(0) or contextMembers instead)</pre>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### null.contextMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
NULL.contextMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ContextMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tuple.contextMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
([Geography].[Geo].[Spain],[Product].[Licence].[Personal]).contextMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ContextMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### level.contextMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
[Geography].[Geo].[Continent].contextMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ContextMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### memberSet.contextMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]}.contextMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ContextMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### tupleSet.contextMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
{([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])}.contextMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ContextMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### string.contextMember

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
"hello".contextMember
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ContextMember() : argument (0) type mismatch: expected:'hierarchy|dimension|namedSet', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[ContextMembers](ContextMembers.md)

[CurrentMember](CurrentMember.md)

[Current](Current.md)

[Exists](Exists.md)

[Axis](Axis.md)

[Slicer](Slicer.md)

[SubSelectAxis](SubSelectAxis.md)

[GetFilterInfo](GetFilterInfo.md)

[Same Hierarchy Tuple](Same%20Hierarchy%20Tuple.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
