## CompactSet

Returns a 'compacted' set


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |set-expression | | |



### Return

```
set
```



### Description

For a set of members (not tuples), returns a compact set. The algorithm replaces when found all children of a parent by their parent and this recursively.

The final set is a smaller set of members that generates the same aggregated value as the original set.

As an example, let's take the time dimension with years, month and days as levels. If we take a set with all days from [2 Jan 2009] until [2 Jan 2012], the compactSet function will return a set with the following members : {2 Jan 2009:31 Jan2009} + {Feb 2009:Dec 2009} + {2010} + {1 Jan 2012:2 Jan 2012}. This reduced drastically the number of members while generating the same aggregated value.

CompactSet will not do any optimization if the hierarchy is not a 'standard' one, meaning each parent is strictly the aggregation of his children. This can happen if fact data is added to no leaf members as well as the hierarchy does not aggregate member's fact data to his ancestors (it is a hierarchy attribute). To 'force' compactSet you might use CompactSetX function.

The icCube.xml file contains the property icCube.compactSetInSubSelect that allows to wraps each sub-select axis expression into a CompactSet function call for performance reason. It is defined as true at the time of writing this documentation.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CompactSet(member-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the compact set. In our example, all the quarters of 2005 are replaced by the year itself [Time].[2005].

**Query**

```
CompactSet({[Time].[Q1 2010], [Time].[Q2 2010], [Time].[Q3 2010], [Time].[Q4 2010] })
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Year].[2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Time].[2010] }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CompactSet(member-set) - II

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the compact set. A bit more complex than the first example with a larger period and involving months, quarters and years.

**Query**

```
CompactSet({[Time].[Mar 2010]:[Time].[Mar 2011]})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Mar 2010], 
  [Time].[Calendar].[Quarter].[Q2 2010], 
  [Time].[Calendar].[Quarter].[Q3 2010], 
  [Time].[Calendar].[Quarter].[Q4 2010], 
  [Time].[Calendar].[Quarter].[Q1 2011]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{ [Time].[Mar 2010],[Time].[Q2 2010],[Time].[Q3 2010],[Time].[Q4 2010],[Time].[Q1 2011] }
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CompactSet(member-set) - no optimization possible

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the input set if no optimization is possible

**Query**

```
CompactSet({[Time].[Q1 2010], [Time].[Q2 2010], [Time].[Q4 2010] })
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Quarter].[Q1 2010], 
  [Time].[Calendar].[Quarter].[Q2 2010], 
  [Time].[Calendar].[Quarter].[Q4 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Time].[Q1 2010], [Time].[Q2 2010], [Time].[Q4 2010]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CompactSet(member-set) - all members

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the [All] member if all members of a level are specified.

**Query**

```
CompactSet( [Geography].[Geo].[City].members)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[All Regions]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[All Regions]}
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CompactSet(tuple-set)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the input set if it is a set of tuples.

**Query**

```
CompactSet( {[Geography].[Geo].[Europe]} * {[Time].[Mar 2010]:[Time].[Mar 2011]} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Mar 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Apr 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[May 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Jun 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Jul 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Aug 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Sep 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Oct 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Nov 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Dec 2010] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Jan 2011] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Feb 2011] ), 
  ( [Geography].[Geo].[Continent].[Europe], [Time].[Calendar].[Month].[Mar 2011] )
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Europe]} * {[Time].[Mar 2010]:[Time].[Mar 2011]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CompactSet({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Applying CompactSet to empty sets results in an empty set.

**Query**

```
CompactSet({})
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


 
</div>

                                                                         

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
