## Comments

Comments syntax used in MDX expressions.




### Description

MDX allows for adding comments in a query. Valid comments:

a) // This is a comment ending with the line

b) /* This is a comment that can span
different lines as in C++ */

c) -- This is another comment ending with the line



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Comment : /*... */ syntax 

</div>

<div class="ic3-mdx-example-body" style="display:none">

Characters (possibly spanning several lines) in between /* */ are considered as comment.

**Query**

```
SELECT
    [Measures]./* I'm a comment */ DefaultMember ON 0,
    [Geography].[Geo].[Continent].Members ON 1
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    [Measures]./* I'm a comment */ DefaultMember ON 0,
    [Geography].[Geo].[Continent].Members  ON 1
FROM
    /*
       I'm a comment
    */
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Comment : // syntax

</div>

<div class="ic3-mdx-example-body" style="display:none">

// begins a comment that extends to the end of the line

**Query**

```
SELECT
    [Measures].DefaultMember ON 0,
     [Geography].[Geo].[Continent].Members ON 1 // I'm a comment
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT
    [Measures].DefaultMember ON 0, // I'm a comment
    [Geography].[Geo].[Continent].Members ON 1
FROM
   [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Comment : -- syntax

</div>

<div class="ic3-mdx-example-body" style="display:none">

// begins a comment that extends to the end of the line

**Query**

```
SELECT  -- I'm a comment
    [Measures].DefaultMember ON 0, -- I'm a comment too
    [Geography].[Geo].[Continent].Members ON 1
FROM
   [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255</td>
</tr>
</table>



**Assertion : Cell Equals**

```
SELECT  -- I'm another comment
    [Measures].DefaultMember ON 0,
    [Geography].[Geo].[Continent].Members ON 1 -- I'm again a comment

FROM
   [Sales]
```


 
</div>

                                                                                                            

### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
