## CoalesceEmpty

Returns the first non-empty numeric value from the parameters list.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |numeric-expression |one-n | |



### Return

```
numeric-value
```



### Description

The function returns the first non-empty/null numeric value among the list of parameters.

Usually used to handle nulls, division by zero and/or add a default numeric value.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CoalesceEmpty(NULL,numeric,numeric,...)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the first non empty value from the parameters.

**Query**

```
WITH
    MEMBER [Measures].[P] AS CoalesceEmpty(null,2,3)
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">P</td>
</tr>
<tr>
 <td>2</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[P] AS 2
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CoalesceEmpty(NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if all parameters are NULL entities.

**Query**

```
WITH
    MEMBER [Measures].[P] AS IsEmpty( CoalesceEmpty(null) )
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">P</td>
</tr>
<tr>
 <td>true</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[P] AS True
SELECT
    [Measures].[P] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### CoalesceEmpty()

</div>

<div class="ic3-mdx-example-body" style="display:none">

Generates an error if no parameter is specified.

**Query**

```
CoalesceEmpty()
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_UNEXPECTED_ARGUMENT_COUNT](icCubeError.md#olap_function_unexpected_argument_count)</td></tr><tr><td>Error Message</td><td>

CoalesceEmpty() : unexpected number of parameters '0' (expected:'2147483647,1')</td></tr></table>


 
</div>

                                                                         

### See Also


[CoalesceNull](CoalesceNull.md)

[Iif](Iif.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
