## ClosingPeriod

Returns the last sibling for the specified level. Optionally member can be specified for the search.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |level-expression |zero-one | |
| |member-expression |zero-one | |



### Return

```
member
```



### Description

This function finds the last sibling from descendants of the specified member at the specified level.

1) If no parameters were specified, function will use implicitly time dimension current member and its next level.

2) If only level was specified, function will use default member implicitly.

The same result can be achieved with Tail(Descendants(Member_Expression, Level_Expression), 1) MDX statement.

Function is primary intended to be used with Time dimensions (however it's not a restriction).



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod(level,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the last member of members descendants at the specified level.

In our example the last month of [2010] year.

**Query**

```
ClosingPeriod( [Time].[Calendar].[Month], [Time].[Calendar].[Year].[2010] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Dec 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Tail(Descendants([Time].[Calendar].[Year].[2010], [Time].[Calendar].[Month]), 1)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the last member of the default member of level's hierarchy at the specified level.

function behaves as ClosingPeriod([Time].[Calendar].[Month],[Time].[Calendar].[Year].defaultmember)

**Query**

```
ClosingPeriod([Time].[Calendar].[Month])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Time].[Calendar].[Month].[Dec 2010]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
ClosingPeriod([Time].[Calendar].[Month], [Time].[Calendar].defaultmember)
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod()

</div>

<div class="ic3-mdx-example-body" style="display:none">

If no parameter is specified:
- the member is the current member of the time dimension.
- the level is the level of former member + 1

function behaves as ClosingPeriod([Time].[Calendar].DefaultMember.level,[Time].[Calendar].DefaultMember)

**Query**

```
WITH
    member ClosingName as ClosingPeriod().NAME
SELECT
    ClosingName on 0, [Time].[Calendar].[Year].members on 1
FROM
    Sales
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">ClosingName</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">2010</td>
 <td>Q4 2010</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">2011</td>
 <td>Q4 2011</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    member ClosingName as ClosingPeriod([Time].[Calendar].CurrentMember.firstChild.level,[Time].[Calendar].CurrentMember).NAME
SELECT
    ClosingName on 0, [Time].[Calendar].[Year].members on 1
FROM
    Sales
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod(level,member) - non-time dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">

ClosingPeriod can be applied not only for Time data. In general it returns last sibling among descendants of the specified member for the specified level.

**Query**

```
ClosingPeriod( [Geography].[Geo].[City], [Geography].[Geo].[Spain] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Valencia]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Spain].LastChild
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod(level,member) - level is ancestor

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the level is of lower depth than the member.

**Query**

```
ClosingPeriod( [Geography].[Geo].[Continent], [Geography].[Geo].[Spain] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod(NULL,member)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
ClosingPeriod(NULL,[Time].[Calendar].[Year].[2011])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

ClosingPeriod() : argument (0) type mismatch: expected:'level', got:'NULL'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod(level,NULL)

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
ClosingPeriod([Time].[Calendar].[Month],NULL)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### ClosingPeriod(level,member) - member from another dimension

</div>

<div class="ic3-mdx-example-body" style="display:none">



**Query**

```
ClosingPeriod([Time].[Calendar].[Month],[Geography].[Geo].[Paris])
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

unexpected hierarchy (expected:'[Time].[Calendar]') (actual:'[Geography].[Geo]')</td></tr></table>


 
</div>

                                                                         

### See Also


[OpeningPeriod](OpeningPeriod.md)

[FirstChild](FirstChild.md)

[LastSibling](LastSibling.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
