## Caption

Returns the caption of a specified dimension, hierarchy, level, or member.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |expression |one | |



### Return

```
string
```



### Description

Returns the caption (aka. localized name) of a specified dimension, hierarchy, level, or member.
The name is returned if no caption has been defined.

Use the [schema localization](../user_guide/schemas_cubes/localization.md) to define and localize
the caption of any MDX entity.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Caption( member ) as Name

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the name of the country [Spain] because no caption has been explicitly defined.

**Query**

```
WITH
    MEMBER [Spain Caption] AS [Geography].[Geo].[Spain].caption
SELECT
    [Spain Caption] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Spain Caption</td>
</tr>
<tr>
 <td>Spain</td>
</tr>
</table>



**Assertion : Cell Equals**

```
WITH
    MEMBER [Spain Caption] AS [Geography].[Geo].[Spain].name
SELECT
    [Spain Caption] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[Name](Name.md)

[Description](Description.md)

[CAPTION](cellProperties/CAPTION.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
