## Axis

Returns the set of tuples on a specified axis.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|axis-number |numeric-expression | | |



### Return

```
set
```



### Description

The axis-number is zero-based : axis(0) returns the columns axis, axis(1) returns the rows axis, and so on.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Calculated Member

</div>

<div class="ic3-mdx-example-body" style="display:none">

In our example, we're using the Axis(1) function to retrieve the tuples selected on ROWS to compute their sum to compare with each tuple value.

**Query**

```
WITH
    MEMBER [Measures].[Total Amount] as Sum( Axis(1), [Measures].[Amount] )
SELECT
    { [Measures].[Amount], [Measures].[Total Amount] } ON 0,
    { [Geography].[Geo].[France], [Geography].[Geo].[Spain] } ON 1
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
  <td class="ic3-mdx-result-cell-header">Total Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4</td>
 <td>7</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3</td>
 <td>7</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Total Amount] as Sum( { [Geography].[Geo].[France], [Geography].[Geo].[Spain] }, [Measures].[Amount] )
SELECT
    { [Measures].[Amount], [Measures].[Total Amount] } ON 0,
    { [Geography].[Geo].[France], [Geography].[Geo].[Spain] } ON 1
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[SubSelectAxis](SubSelectAxis.md)

[Slicer](Slicer.md)

[ContextMember](ContextMember.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
