## Avg

Compute the average value over the specified set.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
|set |set-expression |one | |
|value |value-expression |zero-one |[Measures].currentMember |



### Return

```
value
```



### Description

The avg function calculates the average value of the non-empty cells. Empty cells are ignored.

1) A value expression is specified.

When the value expression is specified, the measure is evaluated over the set and its average value is returned.

2) A value expression is not specified.

If a value expression is not specified, the measure is taken from the current context.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Avg(set,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the average of the numeric function applied over the tuples of the set.

In our example we're calculating the average as ( 1.0 + 3.0 ) / ( 1 + 1), ignoring the empty value.

**Query**

```
WITH
    MEMBER [Geography].[Geo].[1]     AS 1.0
    MEMBER [Geography].[Geo].[3]     AS 3.0
    MEMBER [Geography].[Geo].[Empty] AS Null

    MEMBER [Measures].[Avg Amount] AS Avg( { [Geography].[Geo].[1],[Geography].[Geo].[3], [Geography].[Geo].[Empty] }, [Measures].[Amount] )
SELECT
    [Measures].[Avg Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Avg Amount</td>
</tr>
<tr>
 <td>2.0</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[Avg Amount] AS 2.0
SELECT
    [Measures].[Avg Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### WAvg(set,numeric,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the weighted average of the numeric function applied over the tuples of the set.

In our example we're calculating the weighted average with a constant weight of 2.

**Query**

```
WITH
    MEMBER [Measures].[WAvg Amount] AS WAvg( [Geography].[Economy].members, 2, [Measures].[Amount] )
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">WAvg Amount</td>
</tr>
<tr>
 <td>383.625</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[WAvg Amount] AS Avg( [Geography].[Economy].members, [Measures].[Amount] )
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### WAvg(set,numeric,numeric) - II

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the weighted average of the numeric function applied over the tuples of the set.

In our example we're calculating the weighted average with a variable weight.

**Query**

```
WITH
    MEMBER [Measures].[WAvg Amount] AS WAvg( [Geography].[Economy].members, [Measures].[Amount] / 2, [Measures].[Amount] )
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">WAvg Amount</td>
</tr>
<tr>
 <td>765.4802867383513</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [Measures].[weight] AS ( [Measures].[Amount]  / 2)
    MEMBER [Measures].[value] AS ( [Measures].[Amount]  )
    MEMBER [Measures].[WAvg Amount.1] AS Avg( [Geography].[Economy].members, [Measures].[weight]*[Measures].[value] )
    MEMBER [Measures].[WAvg Amount.2] AS Avg( [Geography].[Economy].members, [Measures].[weight] )
    MEMBER [Measures].[WAvg Amount] AS [Measures].[WAvg Amount.1] / [Measures].[WAvg Amount.2]
SELECT
    [Measures].[WAvg Amount] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Avg(NULL), Avg({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the member is a NULL entity.

**Query**

```
Avg( {} )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
Avg( NULL )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### WAvg(NULL), WAvg({})

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the member is a NULL entity.

**Query**

```
WAvg( {},1,1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
WAvg( NULL,1, )
```


 
</div>

                                                                         

### See Also


[Count](Count.md)

[Sum](Sum.md)

[Min](Min.md)

[Max](Max.md)

[Median](Median.md)

[Percentile](Percentile.md)

[WAvg](WAvg.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
