## Annotations

Annotations allows for adding some sort of meta-data to MDX elements.




### Description

icCube annotations are adding meta-data facility to the MDX elements. They can be placed in different parts of a `SELECT` statements to modify their behaviors. For example, the evaluation cache can be activated or deactivated using an annotation. The following examples are giving more details about existing annotations.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Prop

</div>

<div class="ic3-mdx-example-body" style="display:none">

Annotating the SELECT keyword, the #Prop annotation allows for overriding MDX read/write properties as defined in the icCube.xml file. The example is showing how to reset the icCube.mdxEvalFastNonEmptyAxis property.

The list of properties is available [here](icCubeXmlaPropertyDescription.md).

**Query**

```
//#prop( icCube.mdxEvalFastNonEmptyAxis = false )
SELECT
  [Measures].[Amount] on 0,
  NON EMPTY [Geography].[Geo].members on 1
FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-empty"></td>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">All Regions</td>
 <td>1023</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;America</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;United States</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;New York</td>
 <td>768</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;Europe</td>
 <td>255</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;France</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Paris</td>
 <td>4</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Spain</td>
 <td>3</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Barcelona</td>
 <td>2</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Madrid</td>
 <td>1</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switzerland</td>
 <td>248</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Geneva</td>
 <td>128</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Lausanne</td>
 <td>56</td>
</tr>
<tr>
<td class="ic3-mdx-result-cell-header">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Zurich</td>
 <td>64</td>
</tr>
</table>



**Assertion : MDX Equals**

```
SELECT
  [Measures].[Amount] on 0,
  NON EMPTY [Geography].[Geo].members on 1
FROM [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### User

</div>

<div class="ic3-mdx-example-body" style="display:none">

Annotating the SELECT keyword, the #User annotation allows for executing the request with the defined role (aka. impersonation) instead of the role of the user executing the request. Note that you must be logged as an administrator to impersonate a user.

**Query**

```
//#User( role = 'administrator' )
SELECT [Measures].[Amount] ON 0 FROM [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">Amount</td>
</tr>
<tr>
 <td>1023</td>
</tr>
</table>



**Assertion : MDX Equals**

```
//#User( role = 'administrator' )
SELECT [Measures].[Amount] ON 0 FROM [Sales]
```


 
</div>

                                                                                                            

### See Also


[Cell Properties](Cell%20Properties.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
