## Ancestors

Returns the ancestor of a specified member at a specified level or distance as a set. Same as Ancestors.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
|level/distance |level-numeric-expression |one | |



### Return

```
set
```



### Description

Despite the 's' in its name this function is equivalent to Ancestor.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(member,level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the Ancestors of member at the specified level as a set.

In our example the [Country] of [Paris] which is [France] as a set.

**Query**

```
Ancestors( [Geography].[Geo].[Paris], [Geography].[Geo].[Country] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[France]}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(member,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the Ancestors at a given distance from the member as a set.

In our example the grandparent of [Paris] which is [Europe]

**Query**

```
Ancestors( [Geography].[Geo].[Paris], 2 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
{[Geography].[Geo].[Paris].Parent.Parent}
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(member,numeric) - same level

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member as a set if distance (numeric) is zero. Same behaviour if we use a level which is equal to the member's level.

**Query**

```
Ancestors( [Geography].[Geo].[Paris], 0 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Ancestors( [Geography].[Geo].[Paris], [Geography].[Geo].[City] )
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Paris]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(member,numeric/level) - no ancestors

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an empty set when the specified member exists and has no ancestor.

**Query**

```
Ancestors([Geography].[Geo].[France], 1024)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Ancestors([Geography].[Geo].[France], [Geography].[Geo].[City])
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(NULL,1)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the member is a NULL entity.

**Query**

```
Ancestors(NULL, 1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(member,numeric) - negative distance

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative distance (numeric) is entered.

**Query**

```
Ancestors([Geography].[Geo].[Paris],-1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_DISTANCE_VALUE](icCubeError.md#olap_invalid_distance_value)</td></tr><tr><td>Error Message</td><td>

Ancestors() : invalid distance value : '-1'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(member,level) - not matching hierarchies

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if level and member does not belong to the same hierarchy.

**Query**

```
Ancestors( [Geography].[Geo].[Paris], [Geography].[Economy].[Country] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

Ancestors() : unexpected hierarchy (expected:'[Geography].[Geo]') (actual:'[Geography].[Economy]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestors(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]),1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestors() : argument (0) type mismatch: expected:'member', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestors([Geography].[Geo].[Continent],1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestors() : argument (0) type mismatch: expected:'member', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestors({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]},1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestors() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestors({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])},1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestors() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestors(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestors("hello",1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestors() : argument (0) type mismatch: expected:'member', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Ancestor](Ancestor.md)

[Ascendants](Ascendants.md)

[IsAncestor](IsAncestor.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
