## Ancestor

Returns the ancestor (i.e., parent) of a specified member at a specified level or distance.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |member-expression |one | |
|level/distance |level-numeric-expression |one | |



### Return

```
member
```



### Description

Either a level expression or a numeric expression can be specified as parameter for this function.

1) The level is specified.

Returns the ancestor of a specified member at the specified level.
Note that if the specified level is the level of the specified member, then the member itself is returned.
Note that if the specified member has no ancestor at the specified level, a NULL value is returned.

2) The distance (i.e., a numerical expression) is specified.

If the specified distance is 0, then the member itself is returned.
If the specified distance is 1, then the member's parent itself is returned.
If the specified distance is 2, then the member's grandparent itself is returned.



             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(member,level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the ancestor of member at the specified level.

In our example the [Country] of [Paris] which is [France]

**Query**

```
Ancestor( [Geography].[Geo].[Paris], [Geography].[Geo].[Country] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Country].[France]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[France]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(member,numeric)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the ancestor at a given distance from the member.

In our example the grandparent of [Paris] which is [Europe]

**Query**

```
Ancestor( [Geography].[Geo].[Paris], 2 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[Continent].[Europe]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
[Geography].[Geo].[Paris].Parent.Parent
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(member,numeric) - same level

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns the member if distance (numeric) is zero. Same behaviour if we use a level which is equal to the member's level.

**Query**

```
Ancestor( [Geography].[Geo].[Paris], 0 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>{
  [Geography].[Geo].[City].[Paris]
}</pre></td></tr></table>


**Assertion : MDX Equals**

```
Ancestor( [Geography].[Geo].[Paris], [Geography].[Geo].[City] )
```


**Assertion : MDX Equals**

```
[Geography].[Geo].[Paris]
```


 
</div>

                                                                                      
### Special Examples (errors, null, ...)

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(NULL,_)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns NULL if the member is a NULL entity.

**Query**

```
Ancestor( NULL, 1 )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td><pre>NULL<pre></td></tr></table>


**Assertion : MDX Equals**

```
Ancestor( [Geography].[Geo].[France], 1024 )
```


**Assertion : MDX Equals**

```
Ancestor( [Geography].[Geo].[France], [Geography].[Geo].[City] )
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(member,numeric) - negative distance

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if a negative distance (numeric) is entered.

**Query**

```
Ancestor([Geography].[Geo].[Paris],-1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_INVALID_DISTANCE_VALUE](icCubeError.md#olap_invalid_distance_value)</td></tr><tr><td>Error Message</td><td>

Ancestor() : invalid distance value : '-1'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(member,level) - not matching hierarchies

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if level and member does not belong to the same hierarchy.

**Query**

```
Ancestor( [Geography].[Geo].[Paris], [Geography].[Economy].[Country] )
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_DIFFERENT_HIERARCHIES](icCubeError.md#olap_different_hierarchies)</td></tr><tr><td>Error Message</td><td>

Ancestor() : unexpected hierarchy (expected:'[Geography].[Geo]') (actual:'[Geography].[Economy]')</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(tuple)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestor(([Geography].[Geo].[Spain],[Product].[Licence].[Personal]),1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestor() : argument (0) type mismatch: expected:'member', got:'tuple'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(level)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestor([Geography].[Geo].[Continent],1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestor() : argument (0) type mismatch: expected:'member', got:'level'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(memberSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestor({[Geography].[Geo].[United States],[Geography].[Geo].[Switzerland],[Geography].[Geo].[Spain]},1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestor() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(tupleSet)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestor({([Geography].[Geo].[United States],[Product].[Licence].[Personal]),([Geography].[Geo].[Spain],[Product].[Licence].[Personal])},1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestor() : argument (0) type mismatch: expected:'member', got:'set'</td></tr></table>


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### Ancestor(string)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns an error if applied to an invalid type.

**Query**

```
Ancestor("hello",1)
```

 
**Result**

<table class="ic3-mdx-result"><tr><td>Error Code</td><td>

[OLAP_FUNCTION_ARGUMENT_TYPE_MISMATCH](icCubeError.md#olap_function_argument_type_mismatch)</td></tr><tr><td>Error Message</td><td>

Ancestor() : argument (0) type mismatch: expected:'member', got:'string'</td></tr></table>


 
</div>

                                                                         

### See Also


[Ancestors](Ancestors.md)

[Ascendants](Ascendants.md)

[IsAncestor](IsAncestor.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
