## AddN

Returns the sum of all parameters, empty if ANY of the parameters is empty or null.


### Parameters

| Name | Type | Cardinality | Default Value |
| - | - | - | - |
| |numeric-expression |one-n | |



### Return

```
numeric-value
```



### Description

This functions sums all parameters values, if any of them is null or empty it will return empty.

AddN(A,B, ... ) = A + B + ... ; empty if any of the parameters is null

Note, this function - in opposition to MinusN,DivN and PercN - does NOT use the third parameter as a CoalesceEmpty shortcut.



### Since Version

4.7


             
### Examples

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddN(A,B)

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns A + B

**Query**

```
WITH
    MEMBER [addN] AS AddN( ([Amount],[Geography].[Spain]) , ([Amount],[Geography].[France]) )
SELECT
    [addN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">addN</td>
</tr>
<tr>
 <td>7</td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [addN] AS ([Amount],[Geography].[Spain]) + ([Amount],[Geography].[France])
SELECT
    [addN] ON 0
FROM
    [Sales]
```


 
</div>

           

<div class="ic3-mdx-example-header ic3-mdx-example-header-collapsed" onclick="ic3_mdx_example_click(this)">

#### AddN(A,B) - empty case

</div>

<div class="ic3-mdx-example-body" style="display:none">

Returns empty if one of the parameters is empty

**Query**

```
WITH
    MEMBER [addN] AS AddN( ([Amount],[Geography].[Spain]) , ([Amount],[Geography].[France],[Time].[2011]) )
SELECT
    [addN] ON 0
FROM
    [Sales]
```

 
**Result**

<table  class="ic3-mdx-result">
<tr>
  <td class="ic3-mdx-result-cell-header">addN</td>
</tr>
<tr>
 <td></td>
</tr>
</table>



**Assertion : MDX Equals**

```
WITH
    MEMBER [addN] AS NULL
SELECT
    [addN] ON 0
FROM
    [Sales]
```


**Assertion : MDX Equals**

```
WITH
    MEMBER [addN] AS AddN( ([Amount],[Geography].[Spain]) , NULL )
SELECT
    [addN] ON 0
FROM
    [Sales]
```


 
</div>

                                                                                                            

### See Also


[MinusN](MinusN.md)

[DivN](DivN.md)

[PercN](PercN.md)


### XMLA Properties

Find [here](icCubeDefaultXmlaProperties.md) the value of the XMLA properties when not specified otherwise.

_
