## icCube REST API : Schema LifeCycle Status

### Schema Load Requests

Schema `load` requests are returning a status with the following values:

    /**
     * Nothing happened (e.g., unloading a non loaded schema).
     */
    NOP
    
    /**
     * Unload successful.
     */
    UNLOADED
    
    /**
     * Full load successful.
     */
    LOADED
    
    /**
     * A load request has been CANCELLED while waiting for a duplicate loading.
     */
    DUPLICATED_LOADING_CANCELLED
    
    /**
     * A blocked (due to simultaneous load limit reached) load request has been CANCELLED.
     */
    WAITING_LOADING_CANCELLED
    
    /**
     * An error occurred during the load of the schema.
     */
    LOAD_ERROR
    
    /**
     * Incremental load successful.
     */
    INCREMENTAL_LOADED
    
    /**
     * Incremental load has been deactivated due to load error: this status means nothing has been done.
     */
    INCREMENTAL_LOAD_DEACTIVATED
    
    /**
     * An error occurred during the incremental load of the schema: the state of the schema is uncertain.
     */
    INCREMENTAL_LOAD_ERROR
    
    /**
     * Unload partitions successful.
     */
    PARTITIONS_UNLOADED
    
    /**
     * Load partitions (or measure group / facts) successful.
     */
    PARTITIONS_LOADED
    
    /**
     * (Un)Load partitions (or measure group / facts) on error: the schema state is still consistent 
     * (e.g., SELECT error, authorization error, etc...).
     */
    PARTITIONS_LOAD_FAILED
    
    /**
     * (Un)Load partitions (or measure group / facts) on error: the state of the schema is uncertain.
     */
    PARTITIONS_LOAD_ERROR

### Schema Status Requests

Schema `status` requests (`SchemaInfo`, `LoadedSchema`, `Unloaded`) are returning a status with the following values:

    /**
     * Schema loaded in the engine.
     */
    LOADED
    
    /**
     * Schema loaded in the engine but the last reload command has failed.
     */
    LOADED_REFRESH_FAILED
    
    /**
     * Schema unloaded in the engine (available for loading).
     */
    UNLOADED
    
    /**
     * Schema unloaded in the engine (available for loading) but the last reload command has failed.
     */
    UNLOADED_REFRESH_FAILED

    /**
     * Schema whose XML definition file (.icc-schema) is invalid.
     */
    INVALID

_
