## icCube REST API Overview

The icCube REST API is based on JSON objects passed over the `HTTP` protocol. For example, the following
`GET` request is retrieving the list of the loaded schemas from an icCube server at `localhost:8282`:

    GET http://localhost:8282/icCube/api/console/admin/LoadedSchemas

Responses are `text/plain` (UTF-8) documents with a JSON object which mainly contain a status and a payload
object specific to each request. For example, requesting the list of loaded schemas might return the following:

    {
        "version": "1",
        "status" : "ok",

        "payload": {
            "header": {
                "headers": [
                    "group",
                    "schema",
                    "schemaDataUpdateTime",
                    "schemaRefreshTimeStart",
                    "schemaRAM",
                    "schemaStatus"
                ]
            },
            "rows": [
                {
                    "cells": [
                        "Demo",
                        "Sales",
                        "19 Sep 2018 14:00:22 CEST",
                        "19 Sep 2018 14:00:22 CEST",
                        "700KB",
                        "LOADED"
                    ]
                }
            ]
        }
    }

_