## UnloadedSchemas

Retrieves the list of unloaded schemas.

### URL

    /icCube/api/console/admin/UnloadedSchemas

### Parameters

| Name   | Type     | Cardinality | Default Value |
|--------|----------|-------------|---------------|
| filter | `string` | zero-n      |               |

### Return (Payload)

    "header": {
        "headers": [
            "group", "schema", "schemaDefinitionUpdateTime", "schemaStatus"
        ]
    },
    "rows": [
        { "cells": [ "Demo", "Sales (TW)", "18 Jul 2018 08:51:13 CEST", "UNLOADED" ] },
        { "cells": [ ...                                                           ] }
    ]

### Description

This request retrieves the list of schemas deployed (that is in `/cubes` directory) in the icCube server
but not loaded yet. Both the `group` and `schema` headers of the response payload can be used in the
[filter](./request_format.md#filter) request.

You can refer to this [page](schema_lifecycle_status.md#schema-status-requests) for more details about
the `schemaStatus` of the schemas.

### See Also

* [LoadedSchemas](LoadedSchemas.md)
* [LoadingSchemas](LoadingSchemas.md)
* [ListSchemas](ListSchemas.md)
* [SchemaInfo](SchemaInfo.md)
* [SchemaFile](SchemaFile.md)

_