## SchemaInfo

Retrieve some information about a schema.

### URL

    /icCube/api/console/admin/SchemaInfo

### Parameters

| Name       | Type     | Cardinality | Default Value |
|------------|----------|-------------|---------------|
| schemaName | `string` | one         |               |
| schemaFile | `string` | zero-one    |               |

### Return (Payload)

    {
        "header": {
            "headers": [
                "property","value"
            ]
        },
        "rows": [
            { "cells": ["name",                   "Sales"                                              ] },
            { "cells": ["status",                 "LOADED"                                             ] },
            { "cells": ["description",            ""                                                   ] },
            { "cells": ["group",                  "Demo"                                               ] },
            { "cells": ["schemaLoadOnStartup",    "Yes"                                                ] },
            { "cells": ["schemaLoadRequest",      "cl_GWT_GwtLoadSchemaQuery_1537454664858_2121139563" ] },
            { "cells": ["schemaDataUpdateTime",   "20 Sep 2018 16:44:25 CEST"                          ] },
            { "cells": ["schemaRefreshTimeStart", "20 Sep 2018 16:44:25 CEST"                          ] },
            { "cells": ["schemaRefreshTimeEnd",   "20 Sep 2018 16:44:25 CEST"                          ] },
            { "cells": ["schemaLoadTime",         "710ms"                                              ] },
            { "cells": ["schemaNextRefreshTime",  "-"                                                  ] },
            { "cells": ["schemaIncrLoad",         "Yes"                                                ] },
            { "cells": ["schemaIncrLoadStatus",   "INCR_LOAD_OK"                                       ] },
            { "cells": ["schemaFactoryFile",      "Sales.icc-schema"                                   ] },
            { "cells": ["schemaRAM",              "700KB"                                              ] }
        ]
    }

### Description

This request retrieves some information about a deployed schema: e.g., its status, its loading time, etc...

When using the `schemaName` parameter, icCube is possibly scanning the content of the `/cubes` directory
(i.e., the deployed schemas) to locate the XML definition file (`.icc-schema` file) containing the schema
whose name is given by the request.

If the name of the schema definition file does not follow the icCube format (i.e., derived from the schema
name) and having a very large number of schema definition files, it is recommended to use instead the
`schemaFile` parameter.

Refer to this [page](schema_lifecycle_status.md#schema-status-requests) for more details about the status
of the schema.

### See Also

* [SchemaFile](SchemaFile.md)

_