## RestoreOffline

Restore a schema offline (aka. snapshot).

### URL

    /icCube/api/console/admin/RestoreOffline

### Parameters

| Name     | Type     | Cardinality | Default Value |
|----------|----------|-------------|---------------|
| name     | `string` | one         |               |
| timeoutS | `number` | zero-one    |               |
| waitS    | `number` | zero-one    |               |
| cancelS  | `number` | zero-one    |               |

### Return (Payload)

    {
        "schemaName" : "Sales",
        "status"     : "LOADED"
    }

### Description

This request restore a schema offline (aka. snapshot).

On completion, the response contains the status of the operation. Refer to this [page](schema_lifecycle_status.md)
for more details about it.

The optional `timeoutS`> allows for defining a maximum elapsed time (in seconds) after which the load of the schema
is cancelled and the completion status of the request is error with the `payload.code = UX_TIMEOUT`.

The optional `waitS` and `cancelS` parameters allows for cancelling ongoing requests. A lengthy request might prevent
the actual load (e.g. incremental load, reload, etc..) of the schema. Unless specified otherwise loading a schema
(or partitions) is performed in two steps. The first step is loading the required data and the second step is actually
updating the already loaded schema. The first step can be performed in parallel of ongoing MDX requests but the second
step requires no more requests are accessing the schema. Therefore, the load is stuck until all requests are completed.
These two parameters allows for cancelling the requests before the second step is performed. Before the second step,
icCube waits for `waitS` seconds, then if it cancels the ongoing requests (if any) and `waits` for cancelS seconds.
Then if there is still some ongoing requests the load fails otherwise icCube proceed with the second step.

### See Also

* [DeleteOffline](DeleteOffline.md)
* [Offlines](Offlines.md)

_