## Partitions

Retrieves the list of partitions of a loaded schemas.

### URL

    /icCube/api/console/admin/Partitions

### Parameters

| Name   | Type     | Cardinality | Default Value |
|--------|----------|-------------|---------------|
| filter | `string` | zero-n      |               |

### Return (Payload)

    "header": {
        "headers": [
            "cube", "facts", "name", "kind" 
        ]
    },
    "rows": [
        { "cells": [ Sales", "Sales", "JPN", "TABLE" ] },
        { "cells": [ Sales", "Sales", "USA", "TABLE" ] },
        { "cells": [ ...                             ] }
    ]

### Description

This request retrieves the list of partitions of a schemas loaded in the icCube server. The kind of partition
can be either NONE or LEVEL or TABLE depending on the kind of facts (aka. measure groups) partitioning being used.
The `cube` and `facts` and `name` and `kind` headers of the response payload can be used in the
[filter](./request_format.md#filter) request.

### See Also

* [LoadPartitions](LoadPartitions.md)
* [LoadedSchemas](LoadedSchemas.md)

_