## OfflineInfo

Retrieve some information about a schema offline (aka. snapshot).

### URL

    /icCube/api/console/admin/OfflineInfo

### Parameters

| Name | Type     | Cardinality | Default Value |
|------|----------|-------------|---------------|
| name | `string` | one         |               |

### Return (Payload)

    {
        "header": {
            "headers": [
                "property","value"
            ]
        },
        "rows": [
            { "cells": [ "name",      "Sales.icc-schema.2018_07_12_08h03m30.1531375410610" ] },
            { "cells": [ "schema",    "Sales"                                              ] },
            { "cells": [ "group",     "Demo"                                               ] },
            { "cells": [ "timestamp", "12 Jul 2018 08:03:30"                               ] },
            { "cells": [ "size",      "76.7KB"                                             ] }
        ]
    }

### Description

This request retrieves some information about a schema offline: e.g., its status, etc...

### See Also

* [Offlines](Offlines.md)
* [RestoreOffline](RestoreOffline.md)
* [DeleteOffline](DeleteOffline.md)
* [Backups](Backups.md)
* [LoadedSchemas](LoadedSchemas.md)

_