## LoadedSchemas

Retrieves the list of loaded schemas.

### URL

    /icCube/api/console/admin/LoadedSchemas

### Parameters

| Name   | Type     | Cardinality | Default Value |
|--------|----------|-------------|---------------|
| filter | `string` | zero-n      |               |

### Return (Payload)

    "header": {
        "headers": [
            "group", "schema", "schemaDataUpdateTime", "schemaRefreshTimeStart", "schemaRAM", "schemaStatus"
        ]
    },
    "rows": [
        { "cells": [ "Demo", "Sales", "20 Sep 2018 10:29:26 CEST", "20 Sep 2018 10:29:25 CEST", "700KB", "LOADED" ] },
        { "cells": [ ...                                                                                          ] }
    ]

### Description

This request retrieves the list of schemas loaded in the icCube server. Both the `group` and `schema` headers
of the response payload can be used in the [filter](./request_format.md#filter) request. You can refer to this
[page](schema_lifecycle_status.md#schema-status-requests) for more details about the `schemaStatus` of the schemas.

### See Also

* [LoadingSchemas](LoadingSchemas.md)
* [UnloadedSchemas](UnloadedSchemas.md)
* [ListSchemas](ListSchemas.md)
* [SchemaInfo](SchemaInfo.md)
* [SchemaFile](SchemaFile.md)

_