## ListSchemas

Retrieves the list of available schemas : loaded, unloaded, loading, ...

### URL

    /icCube/api/console/admin/ListSchemas

### Parameters

| Name | Type | Cardinality | Default Value |
|------|------|-------------|---------------|

### Return (Payload)

    "header": {
        "headers": [
            "schemaFactoryFile", "schemaName", "schemaStatus", "schemaLoading"
        ]
    },
    "rows": [
        { "cells": [ "Sales.icc-schema", Sales", "LOADED", ] },
        { "cells": [ ...                                                                                          ] }
    ]

### Description

This request retrieves the list of schemas available in the icCube server : loaded, unloaded, invalid, ...
You can refer to this [page](schema_lifecycle_status.md#schema-status-requests) for more details about
the `schemaStatus` of the schemas. Note that a `LOADED` can be `LOADING` when its re-load is not yet
completed.

### See Also

* [LoadedSchemas](LoadedSchemas.md)
* [LoadingSchemas](LoadingSchemas.md)
* [UnloadedSchemas](UnloadedSchemas.md)
* [SchemaInfo](SchemaInfo.md)
* [SchemaFile](SchemaFile.md)

_