## DocsListGizmos

Retrieves the list of gizmos (i.e., dashboards, gadgets, etc...) within the server `Docs` repository.

### URL

    /icCube/api/console/admin/DocsListGizmos

### Parameters

| Name     | Type      | Cardinality | Default Value |
|----------|-----------|-------------|---------------|
| type     | `string`  | zero-one    | DASHBOARD     |
| path     | `string`  | zero-one    | shared:       |
| all      | `boolean` | zero-one    | false         |
| noFolder | `boolean` | zero-one    | false         |

### Return (Payload)

    gizmos : TreeNode[];

    // -- With the following definitions --------------------------------- 

    interface TreeNodeI {
    
        kind: TreeNodeKind;
    
        /**
         * e.g., shared:/Live Demo/Overview
         */
        path: string;
    
        /**
         * e.g., Overview
         */
        name: string;
    
    }
    
    interface TreeNodeFolder extends TreeNodeI {
    
        kind: "FOLDER";
    
        children?: TreeNode[];
    
    }
    
    interface TreeNodeReport extends TreeNodeI {
    
        kind: "FILE";
    
    }
    
    type TreeNode = TreeNodeFolder | TreeNodeReport;

### Description

Retrieves the list of gizmos (i.e., dashboards, gadgets, etc...) within the server `Docs` repository.

The optional `type` parameter can be any of the following values: `DASHBOARD`, `GADGET`, `APPLICATION`.

The optional `path` parameter can represent any of the following three areas as displayed in the Dashboards
application:

- **Shared** : this path must be prefixed by the `shared:` string,
- **My Drive** : this path must be prefixed by the `myDrive:` string,
- **All Users** : this path must be prefixed by the `users:` string,

The optional `all` parameter allows for retrieving a subtree of all the gizmos in the specified path.

The optional `noFolder` parameter allows for filtering out the folders from the result.

### Example

The following request is retrieving the flat list of dashboards in the shared folder `/Live Demo/Charts` :

```
POST /icCube/api/console/admin/DocsListGizmos
{                                                
    "type"     : "DASHBOARD",
    "path"     : "shared:/Live Demo/Charts",
    "noFolder" : true                
}
```

with the result :

```
    "gizmos": [
        { "name": "Gauge",         "path": "shared:/Live Demo/Charts/Gauge" },
        { "name": "Divergent Bar", "path": "shared:/Live Demo/Charts/Divergent Bar" },
        ...
    ]
```
_