## DiscoverSchema

Discover the content of a loaded schema (e.g., dimensions, measures, etc...).

### URL

    /icCube/api/console/mdx/DiscoverSchema

### Parameters

| Name       | Type     | Cardinality | Default Value |
|------------|----------|-------------|---------------|
| schemaName | `string` | one         |               |

### Return (Payload)

    DiscoverSchemaResult {
    
        name  : string;
        cubes : DiscoverSchemaCube[];
    
    }
    
    DiscoverSchemaCube {
    
        name         : string;
        caption      : string;
        perspective  : boolean;
    
        dimensions   : DiscoverSchemaDimension[];
        measures     : DiscoverSchemaMember[];
        userMeasures : DiscoverSchemaMember[];
        calcMembers  : DiscoverSchemaMember[];
    
    }
    
    DiscoverSchemaDimension {
    
        uniqueName  : string;
        name        : string;
        caption     : string;
    
        hierarchies : DiscoverSchemaHierarchy[];
    
    }
    
    DiscoverSchemaHierarchy {
    
        uniqueName    : string;
        name          : string;
        caption       : string;
    
        levels        : DiscoverSchemaLevel[];
    
        allMember     : DiscoverSchemaMember;
        defaultMember?: DiscoverSchemaMember;
    
    }
    
    DiscoverSchemaLevelPropertyType = "DB_TYPE_UNSUPPORTED" | "DB_TYPE_UNKNOWN" | "DATE" | "DATETIME" | "BOOLEAN"
    | "DOUBLE" | "FLOAT" | "SHORT" | "INTEGER" | "LONG" | "STRING" | "UPPERCASE_STRING" | "JAVA_OBJECT";
    
    DiscoverSchemaLevelProperty {
    
        name     : string;
        attribute: boolean
        type     : DiscoverSchemaLevelPropertyType;
    
    }
    
    DiscoverSchemaLevelType = "YEAR" | "HALF_YEAR" | "QUARTER" | "MONTH" | "WEEK" | "DAY" | "DAY_MONTH" | "DAY_YEAR"
    | "HOUR" | "HALF_HOUR" | "QUARTER_HOUR" | "MINUTE" | "SECOND";
    
    DiscoverSchemaLevel {
    
        uniqueName  : string;
        name        : string;
        caption     : string;
    
        properties  : DiscoverSchemaLevelProperty[];
    
        all         : boolean;
        type        : DiscoverSchemaLevelType;
    
    }
    
    DiscoverSchemaMemberType = "MEMBER" | "MEASURE" | "USER_MEASURE" | "CALCULATED";
    
    DiscoverSchemaMember {
    
        uniqueName          : string;
        name                : string;
        caption             : string;
    
        type                : DiscoverSchemaMemberType;
    
        visible             : boolean;
        displayFolder?      : string;
        hierarchyUniqueName : string;
    
    }

### Description

This request returns the content of a loaded schema: cubes, dimensions, hierarchies, levels, level member properties,
measures and calculated measures/members. Please refer to Return (Payload) section above for a detailed description
of the response. This description use a Typescript like notation.

_