/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.url.builder;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import oracle.net.url.builder.ConnectDescriptorBuilder;
import oracle.net.url.builder.URLBuilder;
import oracle.net.url.common.DriverType;
import oracle.net.url.common.Node;
import oracle.net.url.common.NodeType;
import oracle.net.url.common.ParameterNode;

class ConnectDescriptorBuilderImpl
implements ConnectDescriptorBuilder {
    private Properties userProperties = new Properties();
    private DriverType driverType = DriverType.DEFAULT;
    private Node rootNode;
    private boolean strictMode = false;

    ConnectDescriptorBuilderImpl() {
    }

    @Override
    public ConnectDescriptorBuilder addProperties(Properties connectionProps) {
        this.userProperties.putAll((Map<?, ?>)connectionProps);
        return this;
    }

    @Override
    public ConnectDescriptorBuilder addProperties(String name, String value) {
        this.userProperties.setProperty(name, value);
        return this;
    }

    @Override
    public ConnectDescriptorBuilder driverType(DriverType dt) {
        this.driverType = dt;
        return this;
    }

    @Override
    public Node rootNode() {
        return this.rootNode;
    }

    @Override
    public Properties connectionProperties() {
        return this.userProperties;
    }

    @Override
    public ConnectDescriptorBuilder strictMode(boolean strictMode) {
        this.strictMode = strictMode;
        return this;
    }

    private Node newRootNode(NodeType type) {
        if (this.rootNode != null) {
            throw new IllegalStateException("RootNode already present");
        }
        if (this.strictMode && !this.isRootNode(type)) {
            throw new IllegalArgumentException("Invalid RootNode Type : " + String.valueOf(type));
        }
        this.rootNode = this.newNode(type, null);
        return this.rootNode;
    }

    @Override
    public <T extends Node> ConnectDescriptorBuilder rootNode(Class<T> rootNodeType, Consumer<T> childNodeConsumer) {
        NodeType type = this.nodeType(rootNodeType);
        childNodeConsumer.accept((Node)rootNodeType.cast(this.newRootNode(type)));
        return this;
    }

    @Override
    public String build() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.driverType.urlPrefix());
        ((AbstractNode)this.rootNode).build(sb);
        if (this.driverType != DriverType.THIN || this.userProperties == null || this.userProperties.isEmpty()) {
            return sb.toString();
        }
        sb.append("?");
        this.userProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> sb.append(key).append("=").append(val).append("&")));
        return sb.substring(0, sb.length() - 1);
    }

    AbstractNode newNode(NodeType type, Node parent) {
        if (type.equals(NodeType.DESCRIPTION_LIST)) {
            return new DescriptionListNodeImpl(this, parent);
        }
        if (type.equals(NodeType.DESCRIPTION)) {
            return new DescriptionNodeImpl(this, parent);
        }
        if (type.equals(NodeType.ADDRESS_LIST)) {
            return new AddressListNodeImpl(this, parent);
        }
        if (type.equals(NodeType.ADDRESS)) {
            return new AddressNodeImpl(this, parent);
        }
        if (type.equals(NodeType.CONNECT_DATA)) {
            return new ConnectDataNodeImpl(this, parent);
        }
        if (type.equals(NodeType.SECURITY)) {
            return new SecurityNodeImpl(this, parent);
        }
        if (type.equals(NodeType.COMPRESSION_LEVELS)) {
            return new CompressionLevelsNodeImpl(this, parent);
        }
        if (type.equals(NodeType.FAILOVER_MODE)) {
            return new FailOverModeNodeImpl(this, parent);
        }
        if (type.equals(NodeType.UNKNOWN_TYPE)) {
            return new UnknownNodeTypeImpl(this, parent);
        }
        throw new IllegalArgumentException("Invalid Node Type : " + String.valueOf(type));
    }

    private boolean isRootNode(NodeType type) {
        return type == NodeType.DESCRIPTION_LIST || type == NodeType.DESCRIPTION || type == NodeType.ADDRESS_LIST || type == NodeType.ADDRESS;
    }

    private <T extends Node> NodeType nodeType(Class<T> node) {
        if (node.equals(ConnectDescriptorBuilder.DescriptionListNode.class)) {
            return NodeType.DESCRIPTION_LIST;
        }
        if (node.equals(ConnectDescriptorBuilder.DescriptionNode.class)) {
            return NodeType.DESCRIPTION;
        }
        if (node.equals(ConnectDescriptorBuilder.AddressListNode.class)) {
            return NodeType.ADDRESS_LIST;
        }
        if (node.equals(ConnectDescriptorBuilder.AddressNode.class)) {
            return NodeType.ADDRESS;
        }
        if (node.equals(ConnectDescriptorBuilder.ConnectDataNode.class)) {
            return NodeType.CONNECT_DATA;
        }
        if (node.equals(ConnectDescriptorBuilder.SecurityNode.class)) {
            return NodeType.SECURITY;
        }
        if (node.equals(ConnectDescriptorBuilder.CompressionLevelsNode.class)) {
            return NodeType.COMPRESSION_LEVELS;
        }
        if (node.equals(ConnectDescriptorBuilder.FailOverModeNode.class)) {
            return NodeType.FAILOVER_MODE;
        }
        if (node.equals(ConnectDescriptorBuilder.UnknownTypeNode.class)) {
            return NodeType.UNKNOWN_TYPE;
        }
        throw new IllegalArgumentException("Invalid Node : " + String.valueOf(node));
    }

    private static abstract class AbstractNode
    implements Node {
        private String name;
        private final NodeType nodeType;
        protected final List<ParameterNode> params;
        protected final ConnectDescriptorBuilderImpl urlBuilder;
        private final Node parent;
        protected final List<Node> childNodes;

        AbstractNode(URLBuilder urlBuilder, Node parent, NodeType type, String name) {
            this.urlBuilder = (ConnectDescriptorBuilderImpl)urlBuilder;
            this.parent = parent;
            this.params = new LinkedList<ParameterNode>();
            this.childNodes = new LinkedList<Node>();
            this.nodeType = type;
            this.name = name == null ? this.nodeType.nodeName() : name;
        }

        AbstractNode(URLBuilder urlBuilder, Node parent, NodeType type) {
            this(urlBuilder, parent, type, null);
        }

        @Override
        public NodeType type() {
            return this.nodeType;
        }

        @Override
        public void name(String name) {
            this.name = name;
        }

        @Override
        public Node param(String name, String value) {
            this.validateParam(name, value);
            this.params.add(new ParameterNodeImpl(name, value));
            return this;
        }

        void validateParam(String name, String value) {
            if (!this.nodeType.isValidParamValue(name, value)) {
                throw new IllegalArgumentException("Invalid value '" + value + "' for the parameter '" + name + "'");
            }
        }

        @Override
        public Node parent() {
            return this.parent;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public List<Node> childNodes() {
            return this.childNodes;
        }

        @Override
        public List<Node> childNodes(NodeType type) {
            return this.childNodes.stream().filter(node -> node.type() == type).collect(Collectors.toList());
        }

        @Override
        public List<ParameterNode> getParams() {
            return this.params;
        }

        @Override
        public <T extends Node> Node addChild(Class<T> childType, Consumer<T> childConsumer) {
            NodeType type = this.urlBuilder.nodeType(childType);
            Node childNode = this.newNode(type);
            childConsumer.accept((Node)childType.cast(childNode));
            return this;
        }

        private Node newNode(NodeType childNodeType) {
            return this.newNode(childNodeType, null);
        }

        private Node newNode(NodeType childNodeType, Map<String, String> params) {
            AbstractNode childNode = this.urlBuilder.newNode(childNodeType, this);
            this.childNodes.add(childNode);
            return childNode;
        }

        URLBuilder urlBuilder() {
            return this.urlBuilder;
        }

        boolean isValidChild(NodeType childNodeType) {
            return this.nodeType.isValidChildType(childNodeType);
        }

        void build(StringBuilder sb) {
            if (this.urlBuilder.strictMode) {
                this.validate();
            }
            sb.append("(");
            sb.append(this.name());
            sb.append("=");
            this.params.forEach(param -> sb.append(param));
            this.childNodes.forEach(child -> ((AbstractNode)child).build(sb));
            sb.append(")");
        }

        void validate() {
            this.validateParams();
            this.validateChildNodes();
        }

        void validateParams() {
            for (ParameterNode param : this.params) {
                if (this.nodeType.isValidParam(param.name())) continue;
                throw new IllegalArgumentException(param.name() + " is not a valid parameter for " + this.name());
            }
        }

        void validateChildNodes() {
            for (Node child : this.childNodes) {
                if (!this.nodeType.isValidChildType(child.type())) {
                    throw new IllegalArgumentException(child.name() + " is not a valid child type for " + this.name());
                }
                if (NodeType.multipleAllowed(this.type(), child.type()) || child.childNodes(child.type()).size() <= 1) continue;
                throw new IllegalArgumentException(String.valueOf(child.type()) + " present more than once in " + this.name());
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.build(sb);
            return sb.toString();
        }
    }

    private static class ParameterNodeImpl
    implements ParameterNode {
        private final String name;
        private final String value;

        ParameterNodeImpl(String name, String value) {
            this.name = name;
            this.value = value;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public String value() {
            return this.value;
        }

        public String toString() {
            return "(" + this.name + "=" + this.value + ")";
        }
    }

    private static class UnknownNodeTypeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.UnknownTypeNode {
        UnknownNodeTypeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.UNKNOWN_TYPE);
        }
    }

    private static class FailOverModeNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.FailOverModeNode {
        FailOverModeNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.FAILOVER_MODE);
        }
    }

    private static class CompressionLevelsNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.CompressionLevelsNode {
        CompressionLevelsNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.COMPRESSION_LEVELS);
        }
    }

    private static class SecurityNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.SecurityNode {
        SecurityNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.SECURITY);
        }
    }

    private static class ConnectDataNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.ConnectDataNode {
        ConnectDataNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.CONNECT_DATA);
        }
    }

    private static class AddressNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.AddressNode {
        AddressNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.ADDRESS);
        }

        @Override
        void validate() {
            super.validate();
            String protocol = this.getParamValue("PROTOCOL");
            if (protocol == null || protocol.isEmpty()) {
                throw new IllegalArgumentException("Protocol can not be null/empty");
            }
            if (protocol.equalsIgnoreCase("tcp") || protocol.equalsIgnoreCase("tcps") || protocol.equalsIgnoreCase("wss")) {
                String host = this.getParamValue("HOST");
                if (host == null || host.isEmpty()) {
                    throw new IllegalArgumentException("Host can not be null/empty");
                }
                String port = this.getParamValue("PORT");
                if (port == null || port.isEmpty()) {
                    throw new IllegalArgumentException("Port can not be null/empty");
                }
            }
        }
    }

    private static class AddressListNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.AddressListNode {
        AddressListNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.ADDRESS_LIST);
        }

        @Override
        void validate() {
            super.validate();
            if (this.childNodes(NodeType.ADDRESS).isEmpty()) {
                throw new IllegalArgumentException("No address nodes found for AddressList");
            }
        }
    }

    private static class DescriptionNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.DescriptionNode {
        DescriptionNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.DESCRIPTION);
        }

        @Override
        void validate() {
            super.validate();
            if (this.childNodes(NodeType.ADDRESS).isEmpty() && this.childNodes(NodeType.ADDRESS_LIST).isEmpty()) {
                throw new IllegalArgumentException("No address nodes found for Description");
            }
        }
    }

    private static class DescriptionListNodeImpl
    extends AbstractNode
    implements ConnectDescriptorBuilder.DescriptionListNode {
        DescriptionListNodeImpl(URLBuilder urlBuilder, Node parent) {
            super(urlBuilder, parent, NodeType.DESCRIPTION_LIST);
        }
    }
}

