/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4jx.helpers;

import org.apache.log4jx.helpers.LogLog;

public abstract class OptionConverter {
    private OptionConverter() {
    }

    public static long toFileSize(String value, long dEfault) {
        if (value == null) {
            return dEfault;
        }
        String s = value.trim().toUpperCase();
        long multiplier = 1L;
        int index = s.indexOf("KB");
        if (index != -1) {
            multiplier = 1024L;
            s = s.substring(0, index);
        } else {
            index = s.indexOf("MB");
            if (index != -1) {
                multiplier = 0x100000L;
                s = s.substring(0, index);
            } else {
                index = s.indexOf("GB");
                if (index != -1) {
                    multiplier = 0x40000000L;
                    s = s.substring(0, index);
                }
            }
        }
        try {
            return Long.parseLong(s) * multiplier;
        }
        catch (NumberFormatException e) {
            LogLog.error("[" + s + "] is not in proper int form.");
            LogLog.error("[" + value + "] not in expected format.", e);
            return dEfault;
        }
    }
}

