/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4jx;

import crazydev.iccube.crac.CRaCUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.log4jx.WriterAppender;
import org.apache.log4jx.helpers.LogLog;
import org.apache.log4jx.helpers.QuietWriter;
import org.crac.Context;
import org.crac.Resource;

public class FileAppender
extends WriterAppender
implements Resource {
    protected boolean fileAppend = true;
    protected String fileName = null;
    protected boolean bufferedIO = false;
    protected int bufferSize = 8192;
    private boolean afterRestoreRequired;

    public FileAppender(String role) {
        CRaCUtils.register((Resource)this, (String)"Audit File [%s]".formatted(role));
    }

    public void beforeCheckpoint(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] Audit File before-checkpoint [%s] [%s]".formatted(this.qw != null, this.fileName));
        this.afterRestoreRequired = false;
        if (this.qw != null) {
            this.qw.close();
            this.afterRestoreRequired = true;
        }
        CRaCUtils.LOG.info("[CRaC] Audit File before-checkpoint [%s] [%s] completed".formatted(this.qw != null, this.fileName));
    }

    public void afterRestore(Context<? extends Resource> context) throws Exception {
        CRaCUtils.LOG.info("[CRaC] Audit File after-restore [%s] [%s]".formatted(this.afterRestoreRequired, this.fileName));
        if (this.afterRestoreRequired && this.fileName != null) {
            FileOutputStream ostream = new FileOutputStream(this.fileName, true);
            Writer fw = this.createWriter(ostream);
            if (this.bufferedIO) {
                fw = new BufferedWriter(fw, this.bufferSize);
            }
            this.setQWForFiles(fw);
        }
        CRaCUtils.LOG.info("[CRaC] Audit File after-restore [%s] [%s] completed".formatted(this.afterRestoreRequired, this.fileName));
    }

    public String getFile() {
        return this.fileName;
    }

    public void setFile(String file) {
        this.fileName = file.trim();
    }

    @Override
    public void activateOptions() {
        if (this.fileName != null) {
            try {
                this.setFile(this.fileName, this.fileAppend, this.bufferedIO, this.bufferSize);
            }
            catch (IOException e) {
                this.errorHandler.error("setFile(" + this.fileName + "," + this.fileAppend + ") call failed.", e, 4);
            }
        } else {
            LogLog.warn("File option not set for appender [].");
            LogLog.warn("Are you using FileAppender instead of ConsoleAppender?");
        }
    }

    protected void closeFile() {
        if (this.qw != null) {
            try {
                this.qw.close();
            }
            catch (IOException e) {
                LogLog.error("Could not close " + String.valueOf(this.qw), e);
            }
        }
    }

    public void setBufferedIO(boolean bufferedIO) {
        this.bufferedIO = bufferedIO;
        if (bufferedIO) {
            this.immediateFlush = false;
        }
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        LogLog.debug("setFile called: " + fileName + ", " + append);
        if (bufferedIO) {
            this.setImmediateFlush(false);
        }
        this.reset();
        FileOutputStream ostream = null;
        try {
            ostream = new FileOutputStream(fileName, append);
        }
        catch (FileNotFoundException ex) {
            String parentName = new File(fileName).getParent();
            if (parentName != null) {
                File parentDir = new File(parentName);
                if (!parentDir.exists() && parentDir.mkdirs()) {
                    ostream = new FileOutputStream(fileName, append);
                }
                throw ex;
            }
            throw ex;
        }
        Writer fw = this.createWriter(ostream);
        if (bufferedIO) {
            fw = new BufferedWriter(fw, bufferSize);
        }
        this.fileName = fileName;
        this.setQWForFiles(fw);
        this.fileAppend = append;
        this.bufferedIO = bufferedIO;
        this.bufferSize = bufferSize;
        this.writeHeader();
        LogLog.debug("setFile ended");
    }

    protected void setQWForFiles(Writer writer) {
        this.qw = new QuietWriter(writer, this.errorHandler);
    }

    @Override
    protected void reset() {
        this.closeFile();
        this.fileName = null;
        super.reset();
    }
}

