/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor.servlet;

import crazydev.common.fs.CdVFileSystem;
import crazydev.common.fs.CdVFileSystemTmpReason;
import crazydev.common.fs.CdVFileSystemUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.request.log.OlapRequestType;
import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.server.http.IcCubeResourceServlet;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.ux.processor.conf.UxComponentConfiguration;
import crazydev.iccube.ux.processor.conf.UxStaticComponentConfiguration;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.util.IO;
import org.jetbrains.annotations.Nullable;

public class UxStaticServlet
extends IcCubeResourceServlet {
    private static final long serialVersionUID = -719655617543201558L;
    private final UxComponentConfiguration configuration;
    private final OlapRuntime runtime;
    private final File tmpDirectory;
    @Nullable
    private HttpField cacheControl;

    public UxStaticServlet(OlapRuntime runtime, File tmpDirectory, UxComponentConfiguration configuration, @Nullable IcCubeMimeTypesConfiguration mimeTypes) {
        super(OlapLoggers.UX_REQUEST, "[UX]", mimeTypes);
        this.configuration = configuration;
        this.runtime = runtime;
        this.tmpDirectory = tmpDirectory;
    }

    public String getEntryPoint() {
        return "/icCube/console/*";
    }

    @Override
    public OlapRequestType getRequestType() {
        return OlapRequestType.UX;
    }

    public void init() throws ServletException {
        String cc;
        super.init();
        UxStaticComponentConfiguration conf = this.configuration.getUxStaticConf();
        if (conf != null && (cc = conf.getInitParameter("cacheControl")) != null) {
            this.cacheControl = new PreEncodedHttpField(HttpHeader.CACHE_CONTROL, cc);
        }
    }

    @Override
    protected void doHandleUnsafe(HttpServletRequest request, HttpServletResponse response, IcCubeServerRequestContext requestContext) throws ServletException, IOException {
        String servletPath = request.getServletPath();
        String uri = request.getRequestURI();
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            response.sendRedirect(response.encodeRedirectURL("/icCube/console/"));
            return;
        }
        if (pathInfo.equals("/")) {
            RequestDispatcher dispatcher = request.getRequestDispatcher("/icCube/console/index.html");
            dispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (pathInfo.startsWith("/admin")) {
            if (pathInfo.equals("/admin")) {
                RequestDispatcher dispatcher = request.getRequestDispatcher("/icCube/console/index.html");
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (pathInfo.equals("/admin/")) {
                String queryString = UxStaticServlet.getQueryString(request);
                response.sendRedirect(response.encodeRedirectURL("/icCube/console/admin" + queryString));
                return;
            }
            this.replyNotFound(request, response, requestContext, pathInfo);
            return;
        }
        if (pathInfo.startsWith("/builder")) {
            if (pathInfo.equals("/builder")) {
                RequestDispatcher dispatcher = request.getRequestDispatcher("/icCube/console/index.html");
                dispatcher.forward((ServletRequest)request, (ServletResponse)response);
                return;
            }
            if (pathInfo.equals("/builder/")) {
                String queryString = UxStaticServlet.getQueryString(request);
                response.sendRedirect(response.encodeRedirectURL("/icCube/console/builder" + queryString));
                return;
            }
            this.replyNotFound(request, response, requestContext, pathInfo);
            return;
        }
        File rsc = this.getEntity(pathInfo);
        if (rsc != null) {
            if ("/index.html".equals(pathInfo)) {
                this.replyIndexHtml(request, response, rsc);
            } else {
                this.replyResource(request, response, rsc);
            }
            return;
        }
        if ("/mdx".equals(pathInfo)) {
            response.sendRedirect(response.encodeRedirectURL("/icCube/report/mdxConsole"));
            return;
        }
        this.replyNotFound(request, response, requestContext, pathInfo);
    }

    private static String getQueryString(HttpServletRequest request) {
        String queryString = request.getQueryString();
        if (CdStringUtils.isNotNullAndNotBlank((String)queryString)) {
            return "?" + queryString;
        }
        return "";
    }

    private File getEntity(String pathInfo) {
        File where = this.runtime.getInstallUxDirectory();
        File rsc = new File(where, pathInfo);
        if (!rsc.exists() || !rsc.isFile()) {
            return null;
        }
        return rsc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replyIndexHtml(HttpServletRequest request, HttpServletResponse response, File resource) throws IOException {
        boolean livedemo = "true".equals(System.getProperty("ic3.livedemo"));
        String csrfToken = this.getCSRFToken(request);
        response.addHeader(HttpHeader.CACHE_CONTROL.asString(), "must-revalidate,no-cache,no-store");
        if (!livedemo && CdStringUtils.isNullOrBlank((String)csrfToken)) {
            this.sendResource(request, response, resource, false);
            return;
        }
        CdVFileSystem vfs = this.runtime.getVfs();
        File indexHtmlFile = vfs.createTmpFile(CdVFileSystemTmpReason.SERVER_UI_INDEX_HTML, this.tmpDirectory);
        try {
            try (FileInputStream in = new FileInputStream(resource);
                 FileOutputStream out = new FileOutputStream(indexHtmlFile);){
                IOUtils.copyLarge((InputStream)in, (OutputStream)out);
            }
            Charset charset = StandardCharsets.UTF_8;
            String indexHtmlContent = Files.readString(indexHtmlFile.toPath(), charset);
            if (!CdStringUtils.isNullOrBlank((String)csrfToken)) {
                indexHtmlContent = indexHtmlContent.replace("ic3-CSRF-Token (DO NOT REMOVE - USED TO GENERATE FILES)", csrfToken);
            }
            if (livedemo) {
                indexHtmlContent = indexHtmlContent.replace("</head>", "<!-- Launched -->\n<script>\n    !function(i,s,o,g,r,a,m){i.Ip2cObject=o;i[o]||(i[o]=function(){\n    (i[o].q=i[o].q||[]).push(arguments)});i[o].l=+new Date;r=s.createElement(g);\n    a=s.getElementsByTagName(g)[0];r.src='//reveal.ip2c.net/8427257.js';\n    a.parentNode.insertBefore(r,a)}(window,document,'ip2c','script');\n            \n    ip2c('verify', '8427257');\n</script>\n</head>");
            }
            Files.writeString(indexHtmlFile.toPath(), (CharSequence)indexHtmlContent, charset, new OpenOption[0]);
            this.sendResource(request, response, indexHtmlFile, true);
        }
        finally {
            CdVFileSystemUtils.deleteQuietly((File)indexHtmlFile);
        }
    }

    private void replyResource(HttpServletRequest request, HttpServletResponse response, File resource) throws IOException {
        if (this.cacheControl != null && !response.containsHeader(HttpHeader.CACHE_CONTROL.asString())) {
            response.setHeader(this.cacheControl.getName(), this.cacheControl.getValue());
        }
        this.sendResource(request, response, resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendResource(HttpServletRequest request, HttpServletResponse response, File resource, boolean delete) throws IOException {
        this.setContentType(response, resource);
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(resource));){
            ServletOutputStream outputStream = response.getOutputStream();
            IO.copy((InputStream)in, (OutputStream)outputStream);
            outputStream.flush();
        }
        finally {
            if (delete) {
                CdVFileSystemUtils.deleteQuietly((File)resource);
            }
        }
    }

    @Override
    protected void setContentType(HttpServletResponse response, String resource) {
        if (resource.contains(CdVFileSystemTmpReason.SERVER_UI_INDEX_HTML.fileName)) {
            super.setContentType(response, "index.html");
        } else {
            super.setContentType(response, resource);
        }
    }
}

