/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor;

import crazydev.common.fs.CdVFileSystem;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.gwt.server.reporting.repository.OlapDocsMimeTypes;
import crazydev.iccube.gwt.server.reporting.repository.docs.OlapDocsActualRepository;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.usecase.repository.UxUseCaseRepositories;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequest;
import crazydev.iccube.ux.processor.UxServerRequestReply;
import java.io.File;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxServerRequestContext
extends IcCubeServerRequestContext<UxServerRequest, UxServerRequestReply> {
    private static final String USE_CASE_REPOSITORIES = "USE_CASE_REPOSITORIES";
    private final UxBabylonService babylon;
    private final UxServerRequestReply reply;
    @Nullable
    private OlapEngineMdxScriptCompilationInfo mdxCompilationInfo;

    public UxServerRequestContext(IcCubeServerSessionContext sessionContext, UxServerRequest request) {
        super(sessionContext, request, request.getBrowsingLocale());
        request.setupMdxRequestProperties(this.olapEngineRequestContext);
        this.babylon = new UxBabylonService(this.getApi(), this.getLocale());
        this.reply = new UxServerRequestReply(request);
    }

    public boolean isForRestApi() {
        return this.getApi() == UxApi.REST;
    }

    public UxApi getApi() {
        return ((UxServerRequest)this.request).getApi();
    }

    @Nullable
    public UxAppType getAppType() {
        return ((UxServerRequest)this.request).getAppType();
    }

    @Nullable
    public String getNavTreeUUID() {
        return ((UxServerRequest)this.request).getNavTreeUUID();
    }

    @Nullable
    public String resolveFactoryFileFromSchemaName(String schemaName) {
        File file = this.olapEngineRequestContext.getFactoryFileFromSchemaName(schemaName);
        if (file == null) {
            return null;
        }
        OlapFile factoryFile = this.createSchemaFactoryFile(false, file);
        return factoryFile.getPath();
    }

    public OlapFile createSchemaFactoryFileFromBackup(String schemaName, String timestamp) {
        M_BackupManager manager = this.getOlapEngineRequestContext().getOrCreateBackupManager();
        return manager.getBackupFactoryFile(schemaName, timestamp);
    }

    public OlapFile createSchemaFactoryFile(boolean forBuilder, String path) {
        OlapDirectoriesResolved directories = this.asRuntimeContext().getDirectoriesResolved();
        File root = path != null && path.endsWith("definition.icc-schema") ? directories.getBackupDirectory() : (forBuilder ? directories.getBuilderDirectory() : directories.getCubesDirectory());
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)root);
        return fs.create(path);
    }

    public OlapFile createSchemaFactoryFile(boolean forBuilder, File file) {
        OlapDirectoriesResolved directories = this.asRuntimeContext().getDirectoriesResolved();
        File root = file != null && file.getName().endsWith("definition.icc-schema") ? directories.getBackupDirectory() : (forBuilder ? directories.getBuilderDirectory() : directories.getCubesDirectory());
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)directories.getVfs(), (File)root);
        File rPath = CdVFileSystem.toRelativePath((File)root, (File)file);
        String rPathS = rPath.getPath();
        return fs.create(rPathS);
    }

    @Override
    public UxServerRequestReply getRequestReply() {
        return this.reply;
    }

    public UxBabylonService getUxBabylonService() {
        return this.babylon;
    }

    public OlapDocsMimeTypes getMimeTypes() {
        return this.sessionContext.getMimeTypes();
    }

    public OlapDocsActualRepository getDocsRepository() {
        return this.sessionContext.getDocsRepository(this.asRuntimeContext());
    }

    @Nullable
    public Locale getBrowsingLocale() {
        return ((UxServerRequest)this.request).getBrowsingLocale();
    }

    @Nullable
    public String getBuilderSnapshot() {
        return ((UxServerRequest)this.request).getBuilderSnapshot();
    }

    public UxUseCaseRepositories getUseCaseRepositories() {
        return this.sessionContext.computeIfAbsentCachedData(USE_CASE_REPOSITORIES, k -> new UxUseCaseRepositories());
    }

    public OlapEngineMdxScriptCompilationInfo getMdxCompilationInfo() {
        if (this.mdxCompilationInfo == null) {
            throw new RuntimeException("internal error: missing MDX script compilation information");
        }
        return this.mdxCompilationInfo;
    }

    public void setMdxCompilationInfo(OlapEngineMdxScriptCompilationInfo compilationInfo) {
        this.mdxCompilationInfo = compilationInfo;
    }
}

