/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.applications.OlapRoleApplicationPermissions;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.builder.factory.schema.IOlapBuilderSchemaDefFactory;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatus;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLifeCycleStatusPhase;
import crazydev.iccube.olap.component.command.builtin.OlapSchemaLoadStatus;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapRuntimeContext;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxHelper;
import crazydev.iccube.olap.component.mdx.OlapEngineMdxScriptCompilationInfo;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingLock;
import crazydev.iccube.olap.component.schemas.OlapSchemaLoadingToken;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.eval.instr.OlapInstrExecListener;
import crazydev.iccube.olap.eval.select.IExecuteStatementInstr;
import crazydev.iccube.olap.goodies.debugger.OlapMdxDebugNodeCollector;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchemaInformation;
import crazydev.iccube.pub.principal.OlapPrincipal;
import crazydev.iccube.request.log.OlapChattyRequest;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.log.OlapRequestInfo;
import crazydev.iccube.request.log.OlapRequestVerbosity;
import crazydev.iccube.request.request.IcCubeRequestCategory;
import crazydev.iccube.request.request.IcCubeRequestKind;
import crazydev.iccube.request.status.IcCubeActiveRequestManager;
import crazydev.iccube.request.status.IcCubeRequestStatusManager;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.request.processor.print.IcCubePrintJob;
import crazydev.iccube.server.request.processor.print.IcCubePrintServletHttpRequest;
import crazydev.iccube.server.request.request.common.IcCubeServerRequest;
import crazydev.iccube.server.request.task.IcCubeServerTask;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxRestoreOfflineQuery;
import crazydev.iccube.ux.admin.queries.schema.lifecycle.UxSchemaLifeCycleStatus;
import crazydev.iccube.ux.common.app.UxAppType;
import crazydev.iccube.ux.common.query.UxExecuteScriptI;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxApi;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.queries.tidyExecute.UxTidyExecuteMdxScriptQuery;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import crazydev.iccube.ux.processor.UxServerRequestReply;
import crazydev.iccube.ux.processor.tasks.UxCreateOfflineWriteServerTask;
import crazydev.iccube.ux.processor.tasks.UxFullLoadSchemaReadServerTask;
import crazydev.iccube.ux.processor.tasks.UxIncrLoadSchemaReadServerTask;
import crazydev.iccube.ux.processor.tasks.UxLoadMeasureGroupReadServerTask;
import crazydev.iccube.ux.processor.tasks.UxLoadMeasureGroupWriteServerTask;
import crazydev.iccube.ux.processor.tasks.UxLoadPartitionsReadServerTask;
import crazydev.iccube.ux.processor.tasks.UxLoadPartitionsWriteServerTask;
import crazydev.iccube.ux.processor.tasks.UxLoadSchemaWriteServerTask;
import crazydev.iccube.ux.processor.tasks.UxSingleServerTask;
import crazydev.iccube.ux.processor.tasks.UxUnloadPartitionsReadServerTask;
import crazydev.iccube.ux.processor.tasks.UxUnloadPartitionsWriteServerTask;
import crazydev.iccube.ux.processor.tasks.UxUnloadSchemaReadServerTask;
import crazydev.iccube.ux.processor.tasks.UxUnloadSchemaWriteServerTask;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class UxServerRequest
extends IcCubeServerRequest<UxServerRequest, UxServerRequestReply, UxServerRequestContext> {
    @Nullable
    private final HttpServletRequest httpRequest;
    private final UxApi api;
    @Nullable
    private final Locale browsingLocale;
    @Nullable
    private String builderSnapshot;
    @Nullable
    private final UxAppType appType;
    @Nullable
    private final String navTreeUUID;
    private final UxQuery uxQuery;
    private boolean isForAllSchemas;
    @Nullable
    private String resolvedSchema;
    private IcCubeSchemaAccessLockMode resolvedSchemaLockMode;
    @Nullable
    private OlapSchemaLoadingToken schemaLoadingToken;
    @Nullable
    private OlapSchemaLoadingLock schemaLoadingLock;
    private boolean isFullLoadSchema;

    public UxServerRequest(UxApi api, @Nullable Locale browsingLocale, @Nullable UxAppType appType, @Nullable String navTreeUUID, HttpServletRequest httpRequest, UxQuery uxQuery) {
        this(api, browsingLocale, appType, navTreeUUID, uxQuery.getRequestId(), httpRequest, uxQuery);
    }

    public UxServerRequest(UxApi api, @Nullable Locale browsingLocale, @Nullable UxAppType appType, @Nullable String navTreeUUID, OlapRequestId requestId, @Nullable HttpServletRequest httpRequest, UxQuery uxQuery) {
        super(requestId);
        this.httpRequest = httpRequest;
        this.api = api;
        this.browsingLocale = browsingLocale;
        this.appType = appType;
        this.navTreeUUID = navTreeUUID;
        this.uxQuery = uxQuery;
    }

    @Override
    @Nullable
    public String getPrintJobUUID() {
        if (this.httpRequest instanceof IcCubePrintServletHttpRequest) {
            IcCubePrintServletHttpRequest pRequest = (IcCubePrintServletHttpRequest)this.httpRequest;
            IcCubePrintJob job = pRequest.getPrintingJob();
            return job.getUuid();
        }
        return null;
    }

    public boolean ignoreCSRFToken() {
        return this.uxQuery != null && this.uxQuery.ignoreCSRFToken();
    }

    @Nullable
    public HttpServletRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Nullable
    public String getCSRFSessionToken() {
        OlapPrincipal principal;
        if (this.httpRequest == null) {
            return null;
        }
        HttpSession session = this.httpRequest.getSession(false);
        if (session != null && (principal = (OlapPrincipal)session.getAttribute("icCube.principal")) != null) {
            String token = principal.getCSRFToken();
            return token;
        }
        return null;
    }

    @Nullable
    public String getCSRFHeaderToken() {
        if (this.httpRequest == null) {
            return null;
        }
        String token = this.httpRequest.getHeader("X-CSRF-TOKEN");
        if (CdStringUtils.isNullOrBlank((String)token)) {
            token = this.httpRequest.getParameter("X-CSRF-TOKEN");
        }
        return token;
    }

    public String toStringForCSRFError() {
        return this.uxQuery.getInternalTypeName() + ": " + (this.httpRequest != null ? this.httpRequest.toString() : "");
    }

    public UxApi getApi() {
        return this.api;
    }

    @Nullable
    public UxAppType getAppType() {
        return this.appType;
    }

    @Nullable
    public String getNavTreeUUID() {
        return this.navTreeUUID;
    }

    @Nullable
    public Locale getBrowsingLocale() {
        return this.browsingLocale;
    }

    @Nullable
    public IcCubeActiveRequestManager.GviInfo getGviInfo(String sessionUUID) {
        String windowUId = this.uxQuery.getWindowUId();
        String widgetUId = this.uxQuery.getWidgetUId();
        Long timestamp = this.uxQuery.getTimestamp();
        if (windowUId != null && widgetUId != null && timestamp != null) {
            String clientUUID = this.getClientUUID();
            return new IcCubeActiveRequestManager.GviInfo(sessionUUID, clientUUID, timestamp, windowUId, widgetUId, false);
        }
        return null;
    }

    @Nullable
    public String getBuilderSnapshot() {
        return this.builderSnapshot;
    }

    public void setBuilderSnapshot(@Nullable String builderSnapshot) {
        this.builderSnapshot = builderSnapshot;
    }

    public UxQuery getQuery() {
        return this.uxQuery;
    }

    public IcCubeRequestCategory getCategory() {
        return IcCubeRequestCategory.UX;
    }

    public IcCubeRequestKind getKind() {
        UxQueryKind kind = this.uxQuery.getKind();
        switch (kind) {
            case LOAD: {
                return IcCubeRequestKind.LOAD;
            }
            case MDX: {
                return IcCubeRequestKind.MDX;
            }
        }
        return IcCubeRequestKind.OTHER;
    }

    public String getInternalTypeName() {
        return this.uxQuery.getInternalTypeName();
    }

    public String getUserFriendlyTypeName() {
        return this.uxQuery.getUserFriendlyTypeName();
    }

    public String getTrackingInfo() {
        return this.uxQuery.getTrackingInfo();
    }

    public void setupMdxRequestProperties(OlapEngineRequestContext requestContext) {
        if (this.uxQuery != null) {
            this.uxQuery.setupMdxRequestProperties(requestContext);
        }
    }

    public Logger getLogger() {
        return OlapLoggers.UX_REQUEST;
    }

    public String getLoggerInfo() {
        return this.uxQuery.getLoggerInfo();
    }

    public boolean isUiMonitored() {
        return this.uxQuery.isMonitored();
    }

    public boolean isLoadMonitoring() {
        return this.uxQuery.isLoadMonitoring();
    }

    @Nullable
    public OlapChattyRequest isChattyRequest() {
        return this.uxQuery.isChattyRequest();
    }

    @Nullable
    public OlapRequestVerbosity getVerbosity() {
        return this.uxQuery.getVerbosity();
    }

    @Nullable
    public String getMdxForCancelReport() {
        return this.uxQuery.getMdxForCancelReport();
    }

    public boolean isMonitoredForTimeout() {
        return this.uxQuery.isMonitoredForTimeout();
    }

    @Nullable
    public String getSchema() {
        return this.resolvedSchema;
    }

    @Override
    public boolean isCreateOfflineOnly() {
        return this.uxQuery.isCreateOfflineOnly();
    }

    @Override
    public boolean isSchemaLifeCycle() {
        return this.uxQuery.isSchemaLifeCycle();
    }

    @Override
    @Nullable
    protected String getSchemaLifeCycleName() {
        if (this.resolvedSchema != null) {
            return this.resolvedSchema;
        }
        return this.uxQuery.getSchemaLifeCycleName();
    }

    @Override
    @Nullable
    protected OlapSchemaLifeCycleStatus getSchemaLifeCycleStatus(UxServerRequestContext requestContext) {
        UxServerRequestReply reply = requestContext.getRequestReply();
        return reply.getSchemaLifeCycleStatus();
    }

    @Override
    @Nullable
    protected OlapSchemaLifeCycleStatusPhase getSchemaLifeCycleStatusPhase(UxServerRequestContext requestContext) {
        UxServerRequestReply reply = requestContext.getRequestReply();
        return reply.getSchemaLifeCycleStatusPhase();
    }

    @Override
    protected boolean unsafeSetupTaskSchedulingInfo(UxServerRequestContext requestContext) throws Exception {
        requestContext.assertUxApplicationAuthorized();
        if (OlapLoggers.UX_REQUEST.isDebugEnabled() && OlapLoggers.isDebugEnabled((OlapChattyRequest)this.isChattyRequest(), (OlapRequestVerbosity)this.getVerbosity())) {
            OlapLoggers.UX_REQUEST.debug((Object)("[UX] request [" + this.uxQuery.getClass().getSimpleName() + "]"));
        }
        this.isForAllSchemas = this.uxQuery.isForAllSchemas();
        if (this.uxQuery.isLoadSchema() && !this.uxQuery.isLoadMeasureGroup() && !this.uxQuery.isLoadPartitions()) {
            OlapFile factoryFile_ = this.uxQuery.getSchemaFactoryFileName(requestContext);
            if (factoryFile_ == null) {
                if (this.uxQuery instanceof UxRestoreOfflineQuery) {
                    throw new RuntimeException(requestContext.getUxBabylonService().translate("offlineSnapshotSchemaFactoryMissing", new Serializable[0]));
                }
                throw new RuntimeException("[UX] missing schema definition file");
            }
            File factoryFile = factoryFile_.__getUnderlying();
            IcCubeRequestStatusManager statusManager = requestContext.getRequestStatusManager();
            statusManager.onRequestAttachedToSchemaDefFactory(this.getClientUUID(), factoryFile);
            OlapEngineRequestContext engineRequestContext = requestContext.getOlapEngineRequestContext();
            IOlapBuilderSchemaDefFactory factory = engineRequestContext.getOrCreateSchemaFactoryForLoad(factoryFile);
            this.resolvedSchema = UxServerRequest.onRequestSchemaResolved(requestContext, factory.getSchemaName());
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            Logger logger = engineRequestContext.getLoggers().uxRequest();
            try {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[UX] acquiring load-token for schema [" + this.resolvedSchema + "]"));
                }
                OlapRequestId requestId = engineRequestContext.getRequestId();
                OlapChattyRequest chattyRequest = this.isChattyRequest();
                OlapRequestVerbosity verbosity = this.getVerbosity();
                OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
                this.schemaLoadingToken = olapEngine.getSchemaLoadToken(engineRequestContext, requestInfo, this.resolvedSchema);
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("[UX] acquired load-token for schema [" + this.resolvedSchema + "]"));
                }
            }
            catch (InterruptedException ex) {
                logger.warn((Object)("[UX] load schema [" + this.resolvedSchema + "] cancelled while waiting for a token"));
                UxServerRequestReply reply = requestContext.getRequestReply();
                reply.reportResponse(null, UxReply.actionSuccess(new UxSchemaLifeCycleStatus(this.resolvedSchema, OlapSchemaLoadStatus.WAITING_LOADING_CANCELLED)));
                return false;
            }
            boolean isDuplicatedLoadSchema = this.isDuplicatedLoadSchema(requestContext, factory);
            if (!isDuplicatedLoadSchema) {
                this.isFullLoadSchema = this.isFullLoadSchema(requestContext, factory);
            }
            return !isDuplicatedLoadSchema;
        }
        if (this.uxQuery instanceof UxTidyExecuteMdxScriptQuery) {
            return this.unsafeSetupTaskSchedulingInfoForMdx(requestContext, (UxTidyExecuteMdxScriptQuery)this.uxQuery);
        }
        this.resolvedSchema = UxServerRequest.onRequestSchemaResolved(requestContext, this.uxQuery.getSchemaName());
        this.resolvedSchemaLockMode = this.uxQuery.getSchemaAccessLockMode();
        return true;
    }

    private boolean unsafeSetupTaskSchedulingInfoForMdx(UxServerRequestContext requestContext, UxExecuteScriptI uxQuery) {
        OlapEngineRequestContext engineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapMdxDebugNodeCollector listener = null;
        if (uxQuery.isForDebug()) {
            listener = new OlapMdxDebugNodeCollector();
        }
        OlapEngineMdxHelper mdxHelper = OlapEngineMdxHelper.create((OlapEngineRequestContext)engineRequestContext, (OlapInstrExecListener)listener, null);
        String schema = uxQuery.getSchema();
        String mdxName = uxQuery.getScriptName();
        String mdxHash = uxQuery.getMdxHash();
        String mdx = uxQuery.getScript();
        OlapEngineMdxScriptCompilationInfo compilationInfo = mdxHelper.compileMdxScript(schema, mdxName, mdx, mdxHash);
        requestContext.setMdxCompilationInfo(compilationInfo);
        this.resolvedSchema = UxServerRequest.onRequestSchemaResolved(requestContext, schema);
        IExecuteStatementInstr scriptInstr = compilationInfo.getInstr();
        this.resolvedSchemaLockMode = scriptInstr != null ? scriptInstr.getSchemaAccessLockMode() : IcCubeSchemaAccessLockMode.NONE;
        return true;
    }

    private static String onRequestSchemaResolved(UxServerRequestContext requestContext, String schemaName) {
        IcCubeRequestStatusManager requestManager = requestContext.getRequestStatusManager();
        String requestUuid = requestContext.getRequestClientUUID();
        requestManager.onRequestSchemaResolved(requestUuid, schemaName);
        return schemaName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDuplicatedLoadSchema(UxServerRequestContext requestContext, IOlapBuilderSchemaDefFactory factory) {
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        Logger logger = olapEngineRequestContext.getLoggers().uxRequest();
        OlapSchemaInformation schemaInformation = new OlapSchemaInformation(this.getClientUUID(), factory.getSchemaGroup(), this.resolvedSchema, factory.getXmlFile(), factory, factory.incrementalLoadActive(), this.uxQuery.getSchemaOfflineSnapshotName());
        if (logger.isInfoEnabled()) {
            logger.info((Object)("[UX] checking duplicated-loading for schema [" + this.resolvedSchema + "]"));
        }
        try {
            block9: {
                do {
                    this.schemaLoadingLock = olapEngine.onSchemaLoadingStarted(olapEngineRequestContext, schemaInformation);
                    if (this.schemaLoadingLock.getStatus() == 0) break block9;
                    requestContext.getOlapEngineRequestContext().onProgressEvent("waitingOnDuplicatedLoading", new Serializable[0]);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!requestContext.isCancelling());
                logger.warn((Object)("[UX] schema [" + this.resolvedSchema + "] cancelled while waiting because of duplicated loading"));
                UxServerRequestReply reply = requestContext.getRequestReply();
                reply.reportResponse(null, UxReply.actionSuccess(new UxSchemaLifeCycleStatus(this.resolvedSchema, OlapSchemaLoadStatus.WAITING_LOADING_CANCELLED)));
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("[UX] duplicated-loading check for schema [" + this.resolvedSchema + "] done"));
            }
        }
    }

    private boolean isFullLoadSchema(UxServerRequestContext requestContext, IOlapBuilderSchemaDefFactory schemaFactory) {
        if (this.uxQuery.isFullLoadSchema()) {
            return true;
        }
        if (this.uxQuery.isLoadPartitions() || this.uxQuery.isLoadMeasureGroup()) {
            return false;
        }
        OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
        OlapRolePermissions elevated = olapEngineRequestContext.elevateForBuilderPermissions();
        OlapRoleApplicationPermissions applicationPermissions = elevated.getApplicationPermissions();
        IOlapSchemasPermission schemasPermissions = elevated.getSchemasPermissions();
        OlapRuntimeContext rContext = requestContext.asRuntimeContext();
        boolean hasSchema = olapEngine.hasAuthorizedSchema(rContext, applicationPermissions, schemasPermissions, this.resolvedSchema);
        return !hasSchema || !schemaFactory.incrementalLoadActive();
    }

    @Override
    protected void setupTasks(List<IcCubeServerTask> tasks, UxServerRequestContext requestContext) {
        if (this.uxQuery.isUnloadPartitions()) {
            tasks.add(new UxUnloadPartitionsReadServerTask(requestContext, this, this.resolvedSchema));
            tasks.add(new UxUnloadPartitionsWriteServerTask(requestContext, this, this.resolvedSchema));
        } else if (this.uxQuery.isLoadPartitions()) {
            tasks.add(new UxLoadPartitionsReadServerTask(requestContext, this, this.resolvedSchema));
            tasks.add(new UxLoadPartitionsWriteServerTask(requestContext, this, this.resolvedSchema));
        } else if (this.uxQuery.isLoadMeasureGroup()) {
            tasks.add(new UxLoadMeasureGroupReadServerTask(requestContext, this, this.resolvedSchema));
            tasks.add(new UxLoadMeasureGroupWriteServerTask(requestContext, this, this.resolvedSchema));
        } else if (this.uxQuery.isLoadSchema()) {
            if (this.isFullLoadSchema) {
                tasks.add(new UxFullLoadSchemaReadServerTask(requestContext, this, this.resolvedSchema));
            } else {
                tasks.add(new UxIncrLoadSchemaReadServerTask(requestContext, this, this.resolvedSchema));
            }
            if (!this.uxQuery.isCreateOfflineOnly()) {
                tasks.add(new UxLoadSchemaWriteServerTask(requestContext, this, this.resolvedSchema));
            } else {
                tasks.add(new UxCreateOfflineWriteServerTask(requestContext, this, this.resolvedSchema));
            }
        } else if (this.uxQuery.isUnloadSchema()) {
            tasks.add(new UxUnloadSchemaReadServerTask(requestContext, this, this.resolvedSchema));
            tasks.add(new UxUnloadSchemaWriteServerTask(requestContext, this, this.resolvedSchema));
        } else {
            tasks.add(new UxSingleServerTask(requestContext, this, this.isForAllSchemas, this.resolvedSchema, this.resolvedSchemaLockMode));
        }
    }

    @Override
    public void onFinallyForSchemaLifeCycleRequest(UxServerRequestContext requestContext) {
        super.onFinallyForSchemaLifeCycleRequest(requestContext);
        if (this.uxQuery.isLoadSchema() && this.schemaLoadingToken != null) {
            OlapEngineComponent olapEngine = requestContext.getOlapEngineComponent();
            OlapEngineRequestContext olapEngineRequestContext = requestContext.getOlapEngineRequestContext();
            OlapRequestId requestId = olapEngineRequestContext.getRequestId();
            OlapChattyRequest chattyRequest = this.isChattyRequest();
            OlapRequestVerbosity verbosity = this.getVerbosity();
            OlapRequestInfo requestInfo = new OlapRequestInfo(requestId, chattyRequest, verbosity);
            olapEngine.releaseSchemaLoadToken(olapEngineRequestContext, requestInfo, this.schemaLoadingToken);
        }
        if (this.uxQuery.isLoadSchema() && this.schemaLoadingLock != null) {
            this.onFinallyForSchemaLoaded(requestContext, this.schemaLoadingLock);
        }
    }
}

