/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor;

import com.google.gson.Gson;
import crazydev.common.lz4.CdLz4;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.fs.OlapPath;
import crazydev.iccube.ux.admin.queries.docs.UxDocsEntryPath;
import crazydev.iccube.ux.common.json.UxJsonUtils;
import crazydev.iccube.ux.common.model.UxModel;
import crazydev.iccube.ux.common.query.UxQueryParserException;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.processor.UxServerRequestJsonParams;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.binary.Base64;
import org.jetbrains.annotations.Nullable;

public class UxServerDecompressedRequestParams {
    private static final String GZ = "_ic3_gz_";
    private static final String GZ_LEN = "_ic3_gz_len_";
    private final Set<String> compressedParamNames = new HashSet<String>();
    private final Map<String, Object> params = new HashMap<String, Object>();

    public UxServerDecompressedRequestParams(@Nullable HttpServletRequest request) {
        Object values;
        String name;
        Map<String, ?> params;
        if (request != null) {
            params = request.getParameterMap();
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                name = (String)entry.getKey();
                values = (String[])entry.getValue();
                if (((String[])values).length == 1) {
                    this.addParam(params, name, values[0]);
                    continue;
                }
                this.addParam(params, name, values);
            }
        }
        if (request != null) {
            params = UxServerRequestJsonParams.create(request);
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                name = (String)entry.getKey();
                values = entry.getValue();
                this.addParam(params, name, values);
            }
        }
    }

    private void addParam(Map<String, ?> requestParams, String name, Object value) {
        if (name.startsWith(GZ_LEN)) {
            return;
        }
        if (!name.startsWith(GZ)) {
            this.params.put(name, value);
            return;
        }
        String paramName = name.substring(GZ.length());
        this.compressedParamNames.add(paramName);
        if (!(value instanceof String)) {
            throw new RuntimeException("internal error : compressed parameter type mismatch [" + name + "]");
        }
        String sValue = (String)value;
        if (CdStringUtils.isNullOrBlank((String)sValue)) {
            this.params.put(name, value);
            return;
        }
        int decompressedLen = this.getCompressedParamLen(requestParams, paramName);
        byte[] compressedUTF8 = Base64.decodeBase64((String)sValue);
        byte[] decompressedUTF8 = CdLz4.decompress((byte[])compressedUTF8, (int)decompressedLen);
        try {
            String decompressed = new String(decompressedUTF8, "UTF-8");
            this.params.put(paramName, decompressed);
        }
        catch (UnsupportedEncodingException unlikely) {
            throw new RuntimeException("internal error : UTF-8 not supported", unlikely);
        }
    }

    private int getCompressedParamLen(Map<String, ?> requestParams, String name) {
        Object value = requestParams.get(GZ_LEN + name);
        if (value == null) {
            throw new RuntimeException("internal error : missing parameter [_ic3_gz_len_" + name + "]");
        }
        if (value instanceof String) {
            String decompressedLenValue = (String)value;
            try {
                int decompressedLen = Integer.parseInt(decompressedLenValue);
                return decompressedLen;
            }
            catch (NumberFormatException ex) {
                throw new RuntimeException("internal error : unexpected parameter [_ic3_gz_len_" + name + "] integer value [" + decompressedLenValue + "]", ex);
            }
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        throw new RuntimeException("internal error : parameter [_ic3_gz_len_" + name + "] type mismatch (expecting string|integer)");
    }

    @Nullable
    public Object getParameter(String name) {
        return this.params.get(name);
    }

    @Nullable
    public String getStringParameter(String name) {
        Object param = this.getParameter(name);
        return param != null ? param.toString() : null;
    }

    @Nullable
    public UxModel getModelParameter(String name) throws UxQueryParserException {
        Object param = this.getParameter(name);
        if (param == null) {
            return null;
        }
        UxModel model = UxModel.fromJson(param);
        if (model != null) {
            return model;
        }
        throw new UxQueryParserException(UxErrorCode.PARAM_TYPE_MISMATCH, new Serializable[]{name, param.getClass().getSimpleName(), "object"});
    }

    @Nullable
    public UxDocsEntryPath getPathParameter(String name) throws UxQueryParserException {
        String json;
        Object param = this.getParameter(name);
        if (param == null) {
            return null;
        }
        if (param instanceof String) {
            OlapPath path = OlapPath.createFromSimplePath((String)((String)param));
            return path != null ? UxDocsEntryPath.fromOlapPath(path) : null;
        }
        Gson gson = UxJsonUtils.gson().create();
        UxDocsEntryPath path = (UxDocsEntryPath)gson.fromJson(json = gson.toJson(param), UxDocsEntryPath.class);
        if (path != null) {
            return path;
        }
        throw new UxQueryParserException(UxErrorCode.PARAM_TYPE_MISMATCH, new Serializable[]{name, param.getClass().getSimpleName(), "path"});
    }

    @Nullable
    public List<String> getStringsParameter(String name) {
        Object param = this.getParameter(name);
        if (param == null) {
            return null;
        }
        if (param instanceof String[]) {
            String[] param_ = (String[])param;
            ArrayList<String> items = new ArrayList<String>();
            for (String value : param_) {
                if (value == null) continue;
                items.add(value.toString());
            }
            return items;
        }
        if (param instanceof List) {
            List param_ = (List)param;
            ArrayList<String> items = new ArrayList<String>();
            for (Object value : param_) {
                if (value == null) continue;
                items.add(value.toString());
            }
            return items;
        }
        return Collections.singletonList(param.toString());
    }

    @Nullable
    public List<Integer> getIntegersParameter(String name) throws UxQueryParserException {
        Object param = this.getParameter(name);
        if (param == null) {
            return null;
        }
        if (param instanceof String[]) {
            String[] param_ = (String[])param;
            ArrayList<Integer> items = new ArrayList<Integer>();
            for (String value : param_) {
                if (value == null) continue;
                items.add(UxServerRequestParams.asIntValue(name, value.toString()));
            }
            return !items.isEmpty() ? items : null;
        }
        if (param instanceof List) {
            List param_ = (List)param;
            ArrayList<Integer> items = new ArrayList<Integer>();
            for (Object value : param_) {
                if (value == null) continue;
                items.add(UxServerRequestParams.asIntValue(name, value.toString()));
            }
            return !items.isEmpty() ? items : null;
        }
        return Collections.singletonList(UxServerRequestParams.asIntValue(name, param.toString()));
    }
}

