/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.processor;

import crazydev.iccube.runtime.OlapRuntime;
import crazydev.iccube.server.configuration.IcCubeMimeTypesConfiguration;
import crazydev.iccube.ux.processor.conf.UxComponentConfiguration;
import crazydev.iccube.ux.processor.servlet.UxApiServlet;
import crazydev.iccube.ux.processor.servlet.UxRestApiServlet;
import crazydev.iccube.ux.processor.servlet.UxStaticServlet;
import java.io.File;
import org.jetbrains.annotations.Nullable;

public class UxComponent {
    private final UxComponentConfiguration configuration;
    @Nullable
    private final UxStaticServlet staticServlet;
    private final UxApiServlet apiServlet;
    private final UxRestApiServlet restApiServlet;

    public UxComponent(OlapRuntime runtime, File tmpDirectory, UxComponentConfiguration configuration, @Nullable IcCubeMimeTypesConfiguration mimeTypes) {
        this.configuration = configuration;
        this.staticServlet = configuration.getUxStaticConf() != null ? new UxStaticServlet(runtime, tmpDirectory, configuration, mimeTypes) : null;
        this.apiServlet = new UxApiServlet();
        this.restApiServlet = new UxRestApiServlet();
    }

    public UxComponentConfiguration getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public UxStaticServlet getStaticServlet() {
        return this.staticServlet;
    }

    public UxApiServlet getApiServlet() {
        return this.apiServlet;
    }

    public UxRestApiServlet getRestApiServlet() {
        return this.restApiServlet;
    }
}

