/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.execute.result;

import crazydev.iccube.ux.UxActionResult;
import crazydev.iccube.ux.mdx.queries.execute.result.UxExecuteMdxError;
import crazydev.iccube.ux.mdx.queries.execute.result.UxExecuteMdxResult;
import crazydev.iccube.ux.mdx.queries.execute.result.UxExecuteMdxResultInfo;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxExecuteMdxScriptResult
extends UxActionResult {
    private final String requestId;
    @Nullable
    private final UxExecuteMdxError error;
    @Nullable
    private final List<UxExecuteMdxResult> results;
    @Nullable
    private final List<UxExecuteMdxResultInfo> infos;

    private UxExecuteMdxScriptResult(String requestId, @Nullable UxExecuteMdxError error, @Nullable List<UxExecuteMdxResult> results, @Nullable List<UxExecuteMdxResultInfo> infos) {
        this.requestId = requestId;
        this.error = error;
        this.results = results == null || !results.isEmpty() ? results : null;
        this.infos = infos == null || !infos.isEmpty() ? infos : null;
    }

    public boolean isMdxOnError() {
        if (this.error != null) {
            return true;
        }
        if (this.results != null) {
            for (UxExecuteMdxResult result : this.results) {
                if (!result.isMdxOnError()) continue;
                return true;
            }
        }
        if (this.infos != null) {
            for (UxExecuteMdxResultInfo info : this.infos) {
                if (!info.isMdxOnError()) continue;
                return true;
            }
        }
        return false;
    }

    public static UxExecuteMdxScriptResult empty(String requestId) {
        return new UxExecuteMdxScriptResult(requestId, null, null, null);
    }

    public static UxExecuteMdxScriptResult createFromError(String requestId, UxExecuteMdxError error) {
        return new UxExecuteMdxScriptResult(requestId, error, null, null);
    }

    public static UxExecuteMdxScriptResult createFromResults(String requestId, List<UxExecuteMdxResult> results) {
        return new UxExecuteMdxScriptResult(requestId, null, results, null);
    }

    public static UxExecuteMdxScriptResult createFromInfos(String requestId, @Nullable List<UxExecuteMdxResultInfo> infos) {
        return new UxExecuteMdxScriptResult(requestId, null, null, infos);
    }
}

