/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.discover;

import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.context.OlapEngineSessionContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.cmember.IOlapCalculatedMembers;
import crazydev.iccube.olap.entity.cmember.OlapCalculatedMemberManager;
import crazydev.iccube.olap.entity.cmember.OlapCubeCalculatedMemberManager;
import crazydev.iccube.olap.entity.dimension.OlapDimension;
import crazydev.iccube.olap.entity.dimension.OlapDimensionMeta;
import crazydev.iccube.olap.entity.hierarchy.OlapHierarchy;
import crazydev.iccube.olap.entity.level.OlapLevel;
import crazydev.iccube.olap.entity.member.OlapMeasureMember;
import crazydev.iccube.olap.entity.member.OlapMember;
import crazydev.iccube.olap.entity.member.OlapUserMeasureMember;
import crazydev.iccube.olap.entity.permissions.IOlapCubePermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionPermission;
import crazydev.iccube.olap.entity.permissions.IOlapDimensionsPermission;
import crazydev.iccube.olap.entity.permissions.IOlapHierarchyPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.properties.member.OlapUserDefinedMemberProperty;
import crazydev.iccube.olap.eval.filter.dimension.OlapMemberFilter;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.query.UxQueryKind;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.UxMdxConsoleQuery;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverCube;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverDimension;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverHierarchy;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverLevel;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverLevelProperty;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverLevelPropertyType;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverLevelType;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverMember;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverMemberType;
import crazydev.iccube.ux.mdx.queries.discover.result.UxDiscoverSchemaResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.Nullable;

public class UxDiscoverSchemaQuery
extends UxMdxConsoleQuery {
    private final String schemaName;

    protected UxDiscoverSchemaQuery(UxQueryMeta meta, OlapRequestId requestId, String schemaName) {
        super(meta, requestId);
        this.schemaName = schemaName;
    }

    @Override
    public UxQueryKind getKind() {
        return UxQueryKind.OTHER;
    }

    @Override
    public boolean isMonitored() {
        return true;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext context;
        OlapEngineComponent engine;
        OlapSchema schema;
        if (OlapLoggers.DISCOVER_SCHEMA.isInfoEnabled()) {
            OlapLoggers.DISCOVER_SCHEMA.info((Object)("[discover] schema [" + this.schemaName + "]"));
        }
        if ((schema = (engine = (context = queryContext.getOlapEngineRequestContext()).getOlapEngineComponent()).getAuthorizedSchema(context, IcCubeSchemaAccessLockMode.READ, this.schemaName)) == null) {
            return UxReply.actionSuccess();
        }
        IOlapSchemaPermission perms = context.getSchemaPermissions(schema);
        List<UxDiscoverCube> cubes = this.discoverCubes(context, perms, schema);
        if (OlapLoggers.DISCOVER_SCHEMA.isInfoEnabled()) {
            OlapLoggers.DISCOVER_SCHEMA.info((Object)("[discover] schema [" + this.schemaName + "] completed"));
        }
        return UxReply.actionSuccess(new UxDiscoverSchemaResult(this.schemaName, cubes));
    }

    private List<UxDiscoverCube> discoverCubes(OlapEngineRequestContext context, IOlapSchemaPermission perms, OlapSchema schema) {
        ArrayList<UxDiscoverCube> discover = new ArrayList<UxDiscoverCube>();
        Locale locale = context.getLocale();
        List cubes = schema.getCubes(perms);
        for (int cc = 0; cc < cubes.size(); ++cc) {
            OlapCube cube = (OlapCube)cubes.get(cc);
            if (OlapLoggers.DISCOVER_SCHEMA.isInfoEnabled()) {
                OlapLoggers.DISCOVER_SCHEMA.info((Object)("[discover] schema [" + this.schemaName + "] : discover cube [" + cube.getNameX() + "] [" + (cc + 1) + "/" + cubes.size() + "]"));
            }
            IOlapCubePermission cPerms = perms.getCubePermissions(cube);
            IOlapDimensionsPermission dPerms = perms.getDimensionsPermissions(cube);
            OlapNameContext nContext = dPerms.getNamingContext(context.getNameContext());
            String name = cube.getName(nContext);
            String caption = cube.getCaption(locale, nContext);
            boolean asPerspective = cube.isPerspective();
            List<UxDiscoverDimension> dimensions = this.discoverDimensions(nContext, locale, cPerms, dPerms, schema, cube);
            List<UxDiscoverMember> measures = this.discoverMeasures(nContext, locale, dPerms.getMemberFilter(), cube);
            List<UxDiscoverMember> userMeasures = this.discoverUserMeasures(context, nContext, locale, dPerms.getMemberFilter(), schema, cube);
            List<UxDiscoverMember> calcMembers = this.discoverCalcMembers(context, nContext, locale, dPerms.getMemberFilter(), schema, cube);
            discover.add(new UxDiscoverCube(name, caption, asPerspective, dimensions, measures, userMeasures, calcMembers));
        }
        return discover;
    }

    private List<UxDiscoverDimension> discoverDimensions(OlapNameContext nContext, Locale locale, IOlapCubePermission cPerms, IOlapDimensionsPermission dPerms, OlapSchema schema, OlapCube cube) {
        ArrayList<UxDiscoverDimension> discover = new ArrayList<UxDiscoverDimension>();
        List dimensions = cube.getDimensionsMeta(locale, cPerms, dPerms);
        for (int dd = 0; dd < dimensions.size(); ++dd) {
            boolean isVisible;
            OlapDimensionMeta meta = (OlapDimensionMeta)dimensions.get(dd);
            if (OlapLoggers.DISCOVER_SCHEMA.isInfoEnabled()) {
                OlapLoggers.DISCOVER_SCHEMA.info((Object)("[discover] schema [" + this.schemaName + "] : discover dimension [" + meta.dimension.getNameX() + "] [" + (dd + 1) + "/" + dimensions.size() + "]"));
            }
            boolean mapped = !meta.measureGroupNames.isEmpty();
            boolean bl = isVisible = !meta.dimension.isFactIndexing() || meta.dimension.isAlwaysVisibleReporting();
            if (!mapped && !isVisible) continue;
            String uniqueName = meta.dimension.getUniqueName(nContext);
            String name = meta.dimension.getName(nContext);
            String caption = meta.dimension.getCaption(locale, nContext);
            List<UxDiscoverHierarchy> hierarchies = this.discoverHierarchies(nContext, locale, dPerms, meta.dimension);
            discover.add(new UxDiscoverDimension(uniqueName, name, caption, hierarchies));
        }
        return discover;
    }

    private List<UxDiscoverHierarchy> discoverHierarchies(OlapNameContext nContext, Locale locale, IOlapDimensionsPermission dPerms, OlapDimension dimension) {
        ArrayList<UxDiscoverHierarchy> discover = new ArrayList<UxDiscoverHierarchy>();
        IOlapDimensionPermission perms = dPerms.getDimensionPermissions(dimension);
        List hierarchies = dimension.getHierarchies(perms);
        for (int hh = 0; hh < hierarchies.size(); ++hh) {
            OlapHierarchy hierarchy = (OlapHierarchy)hierarchies.get(hh);
            String uniqueName = hierarchy.getUniqueName(nContext);
            String name = hierarchy.getName(nContext);
            String caption = hierarchy.getCaption(locale, nContext);
            List<UxDiscoverLevel> levels = this.discoverLevels(nContext, locale, dPerms.getMemberFilter(), perms, hierarchy);
            OlapMember allMember = hierarchy.getAllMember();
            OlapMember defaultMember = hierarchy.getNullableDefaultMember(dPerms.getMemberFilter());
            UxDiscoverMember allMemberD = this.discoverMember(nContext, locale, allMember, UxDiscoverMemberType.MEMBER, true);
            UxDiscoverMember defaultMemberD = this.discoverMember(nContext, locale, defaultMember, UxDiscoverMemberType.MEMBER, true);
            discover.add(new UxDiscoverHierarchy(uniqueName, name, caption, levels, allMemberD, defaultMemberD));
        }
        return discover;
    }

    private List<UxDiscoverLevel> discoverLevels(OlapNameContext nContext, Locale locale, @Nullable OlapMemberFilter memberFilter, IOlapDimensionPermission dPerms, OlapHierarchy hierarchy) {
        ArrayList<UxDiscoverLevel> discover = new ArrayList<UxDiscoverLevel>();
        IOlapHierarchyPermission permission = dPerms.getHierarchyPermission(hierarchy);
        List levels = hierarchy.getLevels(permission);
        for (int ll = 0; ll < levels.size(); ++ll) {
            OlapLevel level = (OlapLevel)levels.get(ll);
            String uniqueName = level.getUniqueName(nContext);
            String name = level.getName(nContext);
            String caption = level.getCaption(locale, nContext);
            ArrayList<UxDiscoverLevelProperty> discoverP = new ArrayList<UxDiscoverLevelProperty>();
            List properties = level.getMemberProperties(memberFilter);
            for (int pp = 0; pp < properties.size(); ++pp) {
                OlapUserDefinedMemberProperty property = (OlapUserDefinedMemberProperty)properties.get(pp);
                String pName = property.getName();
                boolean pAsAttribute = property.isAttribute();
                UxDiscoverLevelPropertyType pType = UxDiscoverLevelPropertyType.valueOf(property.getInputType());
                discoverP.add(new UxDiscoverLevelProperty(pName, pAsAttribute, pType));
            }
            boolean all = level.isAll();
            UxDiscoverLevelType type = UxDiscoverLevelType.valueOf(level.getLevelType());
            discover.add(new UxDiscoverLevel(uniqueName, name, caption, discoverP, all, type));
        }
        return discover;
    }

    private List<UxDiscoverMember> discoverMeasures(OlapNameContext nContext, Locale locale, @Nullable OlapMemberFilter memberFilter, OlapCube cube) {
        ArrayList<UxDiscoverMember> discover = new ArrayList<UxDiscoverMember>();
        List measures = cube.getMeasuresDimension().getMeasureMembers(memberFilter);
        for (OlapMeasureMember measure : measures) {
            discover.add(this.discoverMember(nContext, locale, (OlapMember)measure, UxDiscoverMemberType.MEASURE, true));
        }
        return discover;
    }

    private List<UxDiscoverMember> discoverUserMeasures(OlapEngineRequestContext context, OlapNameContext nContext, Locale locale, @Nullable OlapMemberFilter memberFilter, OlapSchema schema, OlapCube cube) {
        ArrayList<UxDiscoverMember> discover = new ArrayList<UxDiscoverMember>();
        OlapCubeCalculatedMemberManager cubeCalcMemberManager = cube.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = context.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(schema, (OlapCalculatedMemberManager)cubeCalcMemberManager);
        List measures = calcMemberManager.getUserMeasures(memberFilter);
        for (OlapUserMeasureMember measure : measures) {
            discover.add(this.discoverMember(nContext, locale, (OlapMember)measure, UxDiscoverMemberType.USER_MEASURE, true));
        }
        return discover;
    }

    private List<UxDiscoverMember> discoverCalcMembers(OlapEngineRequestContext context, OlapNameContext nContext, Locale locale, @Nullable OlapMemberFilter memberFilter, OlapSchema schema, OlapCube cube) {
        ArrayList<UxDiscoverMember> discover = new ArrayList<UxDiscoverMember>();
        OlapCubeCalculatedMemberManager cubeCalcMemberManager = cube.getCalcMemberManager();
        OlapEngineSessionContext sessionContext = context.getSessionContext();
        IOlapCalculatedMembers calcMemberManager = sessionContext.getCalcMemberManagerForLookup(schema, (OlapCalculatedMemberManager)cubeCalcMemberManager);
        List members = calcMemberManager.getVisibleCalculatedMembers(memberFilter);
        for (OlapMember member : members) {
            discover.add(this.discoverMember(nContext, locale, member, UxDiscoverMemberType.CAlCULATED, true));
        }
        members = calcMemberManager.getInvisibleCalculatedMembers(memberFilter);
        for (OlapMember member : members) {
            discover.add(this.discoverMember(nContext, locale, member, UxDiscoverMemberType.CAlCULATED, false));
        }
        return discover;
    }

    @Nullable
    private UxDiscoverMember discoverMember(OlapNameContext nContext, Locale locale, @Nullable OlapMember member, UxDiscoverMemberType type, boolean visible) {
        if (member == null) {
            return null;
        }
        String uniqueName = member.getUniqueName(nContext);
        String name = member.getName(nContext);
        String caption = member.getCaption(locale, nContext);
        String displayFolder = member.getDisplayFolder(locale, nContext);
        OlapHierarchy hierarchy = member.getHierarchy();
        String hierarchyUniqueName = hierarchy.getUniqueName(nContext);
        return new UxDiscoverMember(uniqueName, name, caption, type, visible, displayFolder, hierarchyUniqueName);
    }
}

