/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.debug;

import crazydev.common.utils.CdArrayUtils;
import crazydev.common.utils.CdTimeUtils;
import crazydev.iccube.gwt.server.requesthandler.debugger.DebugMdxQueryExecTree;
import crazydev.iccube.gwt.server.requesthandler.debugger.GwtDebugMdxQueryExecTreeNodeDetailsQueryHandler;
import crazydev.iccube.gwt.server.requesthandler.debugger.GwtDebugMdxQueryExecTreeNodeQueryHandler;
import crazydev.iccube.gwt.shared.portlets.debugger.model.DebugMdxQueryExecTreeNodeDetails;
import crazydev.iccube.gwt.shared.portlets.debugger.model.DebugMdxQueryExecTreeNodeInfo;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.goodies.debugger.model.OlapMdxDebugNode;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.context.IcCubeServerSessionContext;
import crazydev.iccube.ux.UxFieldKind;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.utils.UxUtils;
import crazydev.iccube.ux.mdx.UxMdxConsoleQuery;
import crazydev.iccube.ux.mdx.queries.debug.result.UxMdxDebugBrowsingNodeDetails;
import crazydev.iccube.ux.mdx.queries.debug.result.UxMdxDebugBrowsingNodeInfo;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UxBrowseMdxDebugDetailsQuery
extends UxMdxConsoleQuery {
    private final String mdxRequestId;
    private final String schemaName;
    private final List<Integer> nodeId;

    protected UxBrowseMdxDebugDetailsQuery(UxQueryMeta meta, OlapRequestId requestId, String mdxRequestId, String schemaName, List<Integer> nodeId) {
        super(meta, requestId);
        this.mdxRequestId = mdxRequestId;
        this.schemaName = schemaName;
        this.nodeId = nodeId;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        IcCubeServerSessionContext serverSessionContext = serverRequestContext.getSessionContext();
        DebugMdxQueryExecTree debugTree = serverSessionContext.getMdxDebuggerTree(this.schemaName);
        if (debugTree == null || !debugTree.getQueryId().equals(this.mdxRequestId)) {
            return UxReply.actionSuccess(new UxMdxDebugBrowsingNodeDetails(UxBrowseMdxDebugDetailsQuery.asInfos(queryContext), null));
        }
        OlapMdxDebugNode debugTreeNode = GwtDebugMdxQueryExecTreeNodeQueryHandler.findNode(debugTree.getRoot(), CdArrayUtils.toIntArray(this.nodeId));
        boolean root = debugTreeNode == debugTree.getRoot();
        OlapRequestNamesContext nameContext = serverRequestContext.getNameContext();
        DebugMdxQueryExecTreeNodeDetails details = new DebugMdxQueryExecTreeNodeDetails(debugTreeNode.getTitle((OlapNameContext)nameContext), debugTreeNode.getFormula(), debugTreeNode.getTuple((OlapNameContext)nameContext), CdTimeUtils.formatMillis((long)debugTreeNode.getExecTimeMillis()), debugTreeNode.isEvalCached(), debugTreeNode.getReturnValueExtraInfo((OlapNameContext)nameContext), debugTreeNode.getFastCrossjoinNonEmptyBehavior(), debugTreeNode.getDefaultMembers((OlapNameContext)nameContext), debugTreeNode.getReturnValue((OlapNameContext)nameContext), debugTreeNode.getReturnType(), GwtDebugMdxQueryExecTreeNodeDetailsQueryHandler.toInfos(debugTreeNode.getInfos()), GwtDebugMdxQueryExecTreeNodeDetailsQueryHandler.createRange(debugTreeNode.getRange()));
        return UxReply.actionSuccess(new UxMdxDebugBrowsingNodeDetails(UxBrowseMdxDebugDetailsQuery.asInfos(queryContext, details, root), UxUtils.setupMdxRange(debugTree.getScriptOffset(), details.getRange())));
    }

    private static List<UxMdxDebugBrowsingNodeInfo> asInfos(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        DebugMdxQueryExecTreeNodeDetails details = new DebugMdxQueryExecTreeNodeDetails(babylon.translate("debug.notAvailable", new Serializable[0]), "", null, "", false, "", null, "", "", "", null, null);
        return UxBrowseMdxDebugDetailsQuery.asInfos(queryContext, details, false);
    }

    private static List<UxMdxDebugBrowsingNodeInfo> asInfos(UxQueryContext queryContext, DebugMdxQueryExecTreeNodeDetails details, boolean root) {
        List<DebugMdxQueryExecTreeNodeInfo> extraFields;
        UxBabylonService babylon = queryContext.getUxBabylonService();
        ArrayList<UxMdxDebugBrowsingNodeInfo> infos = new ArrayList<UxMdxDebugBrowsingNodeInfo>();
        UxBrowseMdxDebugDetailsQuery.addIfNotNull(infos, babylon.translate("debug.instruction", new Serializable[0]), details.getTitle());
        UxBrowseMdxDebugDetailsQuery.addIfNotNull(infos, babylon.translate("debug.value", new Serializable[0]), details.getValue());
        if (!root) {
            infos.add(new UxMdxDebugBrowsingNodeInfo(babylon.translate("debug.type", new Serializable[0]), details.getValueType()));
        }
        UxBrowseMdxDebugDetailsQuery.addIfNotNull(infos, babylon.translate("debug.valueExtraInfo", new Serializable[0]), details.getValueExtraInfo());
        String fastCrossjoinNonEmptyBehavior = details.getFastCrossjoinNonEmptyBehavior();
        if (fastCrossjoinNonEmptyBehavior != null) {
            UxBrowseMdxDebugDetailsQuery.addIfNotNull(infos, babylon.translate("debug.fastCrossjoinNonEmptyBehavior", new Serializable[0]), fastCrossjoinNonEmptyBehavior);
        }
        UxBrowseMdxDebugDetailsQuery.addIfNotNull(infos, babylon.translate("debug.valueDefaultMembers", new Serializable[0]), details.getDefaultMembers());
        UxBrowseMdxDebugDetailsQuery.addIfNotNull(infos, babylon.translate("debug.tuple", new Serializable[0]), details.getTuple());
        if (details.isEvalCached()) {
            infos.add(new UxMdxDebugBrowsingNodeInfo(babylon.translate("debug.cache", new Serializable[0]), babylon.translate("debug.hitFromReqEvalCache", new Serializable[0])));
        }
        if ((extraFields = details.getInfos()) != null) {
            for (DebugMdxQueryExecTreeNodeInfo extraField : extraFields) {
                infos.add(new UxMdxDebugBrowsingNodeInfo(extraField.name, extraField.value));
            }
        }
        UxBrowseMdxDebugDetailsQuery.addIfNotNull(infos, babylon.translate("debug.elapsedTime", new Serializable[0]), details.getExecTime());
        infos.add(new UxMdxDebugBrowsingNodeInfo(babylon.translate("debug.formula", new Serializable[0]), details.getFormula(), UxFieldKind.MDX));
        return UxBrowseMdxDebugDetailsQuery.fix(infos);
    }

    private static void addIfNotNull(List<UxMdxDebugBrowsingNodeInfo> infos, String translatedLabel, String value) {
        if (value != null) {
            infos.add(new UxMdxDebugBrowsingNodeInfo(translatedLabel, value));
        }
    }

    private static List<UxMdxDebugBrowsingNodeInfo> fix(List<UxMdxDebugBrowsingNodeInfo> infos) {
        ArrayList<UxMdxDebugBrowsingNodeInfo> fixed = new ArrayList<UxMdxDebugBrowsingNodeInfo>();
        for (UxMdxDebugBrowsingNodeInfo info : infos) {
            if (!info.isRequiredInUX()) continue;
            fixed.add(info);
        }
        return fixed;
    }
}

