/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.completion;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletion;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletionCellPropertiesContextInfo;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletionContextInfo;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletionSchemaContextInfo;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.UxMdxConsoleQuery;
import crazydev.iccube.ux.mdx.queries.completion.UxMdxCompletionKind;
import crazydev.iccube.ux.mdx.queries.completion.result.UxMdxCompletion;
import crazydev.iccube.ux.mdx.queries.completion.result.UxMdxSuggestion;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UxMdxCompletionQuery
extends UxMdxConsoleQuery {
    private final UxMdxCompletionKind completionKind;
    private final int maxCount;
    @Nullable
    private final String schemaName;
    private final String mdx;
    private final int offset;

    protected UxMdxCompletionQuery(UxQueryMeta meta, OlapRequestId requestId, UxMdxCompletionKind completionKind, int maxCount, @Nullable String schemaName, String mdx, int offset) {
        super(meta, requestId);
        this.completionKind = completionKind;
        this.maxCount = maxCount;
        this.schemaName = CdStringUtils.isNullOrBlank((String)schemaName) ? null : schemaName;
        this.mdx = mdx;
        this.offset = offset;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return this.schemaName != null ? IcCubeSchemaAccessLockMode.READ : IcCubeSchemaAccessLockMode.NONE;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        OlapRequestNamesContext nameContext = engineRequestContext.getNameContext();
        OlapCodeCompletionContextInfo contextInfo = this.setupContextInfo(engineRequestContext);
        List options = OlapCodeCompletion.getSuggestions((OlapRolePermissions)engineRequestContext.getCurrentPermissions(), (OlapRequestNamesContext)nameContext, (int)this.maxCount, (OlapCodeCompletionContextInfo)contextInfo, (String)this.mdx, (int)this.offset);
        List<UxMdxSuggestion> suggestions = options.stream().map(option -> new UxMdxSuggestion(option.getCompletion(), option.getCaption())).collect(Collectors.toList());
        return UxReply.actionSuccess(new UxMdxCompletion(suggestions));
    }

    private OlapCodeCompletionContextInfo setupContextInfo(OlapEngineRequestContext engineRequestContext) {
        OlapSchema schema;
        if (this.completionKind == UxMdxCompletionKind.CELL_PROPERTIES) {
            return new OlapCodeCompletionCellPropertiesContextInfo(engineRequestContext);
        }
        if (this.schemaName != null) {
            OlapEngineComponent olapEngine = engineRequestContext.getOlapEngineComponent();
            schema = olapEngine.getAuthorizedSchema(engineRequestContext, IcCubeSchemaAccessLockMode.READ, this.schemaName);
        } else {
            schema = null;
        }
        return new OlapCodeCompletionSchemaContextInfo(engineRequestContext, schema);
    }
}

