/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.mdx.queries.browser;

import crazydev.common.utils.CdArrayUtils;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.gwt.base.shared.widget.lazytree.model.GwtLazyTreePathTreeNodeIdentifier;
import crazydev.iccube.gwt.server.requesthandler.schemabrowser.LazyTreeSchemaBrowserCommand;
import crazydev.iccube.gwt.server.requesthandler.schemabrowser.LazyTreeSchemaBrowserPrefetchCommand;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.command.GwtSchemaBrowserLazyTreeQuery;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.model.GwtSchemaBrowserTreeInfoModel;
import crazydev.iccube.gwt.shared.portlets.schemabrowser.model.GwtSchemaBrowserTreeNodeModel;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.schema.IOlapSchema;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.request.request.common.IcCubeServerRequestContext;
import crazydev.iccube.ux.builder.common.UxLazyTreeStatus;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.UxMdxConsoleQuery;
import crazydev.iccube.ux.mdx.queries.browser.result.UxSchemaBrowsingNode;
import crazydev.iccube.ux.mdx.queries.browser.result.UxSchemaBrowsingNodeType;
import crazydev.iccube.ux.mdx.queries.browser.result.UxSchemaBrowsingTree;
import crazydev.iccube.ux.processor.UxServerRequestContext;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class UxBrowseSchemaQuery
extends UxMdxConsoleQuery {
    private final String schemaName;
    @Nullable
    private final String treeId;
    @Nullable
    private final List<Integer> nodeId;
    @Nullable
    private final List<Integer> moreParentNodeId;
    @Nullable
    private final Integer moreParentPos;

    protected UxBrowseSchemaQuery(UxQueryMeta meta, OlapRequestId requestId, String schemaName, @Nullable String treeId, @Nullable List<Integer> nodeId, @Nullable List<Integer> moreParentNodeId, @Nullable Integer moreParentPos) {
        super(meta, requestId);
        this.schemaName = schemaName;
        this.treeId = treeId;
        this.nodeId = nodeId;
        this.moreParentNodeId = moreParentNodeId;
        this.moreParentPos = moreParentPos;
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return IcCubeSchemaAccessLockMode.READ;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        OlapEngineComponent olapEngine = engineRequestContext.getOlapEngineComponent();
        OlapSchema schema = olapEngine.getAuthorizedSchema(engineRequestContext, IcCubeSchemaAccessLockMode.READ, this.schemaName);
        ArrayList<IOlapSchema> schemas = new ArrayList<IOlapSchema>();
        if (schema != null) {
            schemas.add((IOlapSchema)schema);
        }
        UxSchemaBrowsingTree result = this.moreParentNodeId != null ? this.doExecuteForMoreNode(queryContext, olapEngine, schemas) : this.doExecuteForRegularNode(queryContext, olapEngine, schemas);
        return UxReply.actionSuccess(result);
    }

    private UxSchemaBrowsingTree doExecuteForMoreNode(UxQueryContext queryContext, OlapEngineComponent engine, List<IOlapSchema> schemas) {
        if (this.moreParentNodeId == null || this.moreParentNodeId.isEmpty() || this.moreParentPos == null) {
            return new UxSchemaBrowsingTree(null, this.treeId, this.nodeId, null);
        }
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        GwtLazyTreePathTreeNodeIdentifier parentNodeId = new GwtLazyTreePathTreeNodeIdentifier(this.schemaName, CdArrayUtils.toIntArray(this.moreParentNodeId));
        GwtSchemaBrowserLazyTreeQuery serverQuery = new GwtSchemaBrowserLazyTreeQuery(this.treeId, "n/a", parentNodeId, this.schemaName);
        int maxChildrenCount = serverRequestContext.getServerProperties().getMaxChildrenCountForSchemaBrowser();
        String engineUID = "" + engine.getSchemasUuid(queryContext.asRuntimeContext());
        LazyTreeSchemaBrowserCommand cmd = new LazyTreeSchemaBrowserCommand(serverRequestContext, this.moreParentPos, maxChildrenCount, serverQuery, engineUID, schemas);
        GwtSchemaBrowserTreeInfoModel tree = (GwtSchemaBrowserTreeInfoModel)cmd.call();
        List<UxSchemaBrowsingNode> nodes = UxBrowseSchemaQuery.asNodes(this.moreParentPos, tree.getNodeModels());
        return new UxSchemaBrowsingTree(tree.isOutOfSync() ? UxLazyTreeStatus.OUT_OF_SYNC : null, tree.getServerTreeUId(), this.nodeId, nodes);
    }

    private UxSchemaBrowsingTree doExecuteForRegularNode(UxQueryContext queryContext, OlapEngineComponent engine, List<IOlapSchema> schemas) {
        GwtSchemaBrowserTreeInfoModel tree;
        UxServerRequestContext serverRequestContext = queryContext.asServerRequestContext();
        GwtLazyTreePathTreeNodeIdentifier parentNodeId = new GwtLazyTreePathTreeNodeIdentifier(this.schemaName, this.nodeId != null && !this.nodeId.isEmpty() ? CdArrayUtils.toIntArray(this.nodeId) : null);
        GwtSchemaBrowserLazyTreeQuery serverQuery = new GwtSchemaBrowserLazyTreeQuery(this.treeId, "n/a", parentNodeId, this.schemaName);
        int maxChildrenCount = serverRequestContext.getServerProperties().getMaxChildrenCountForSchemaBrowser();
        String engineUID = "" + engine.getSchemasUuid(queryContext.asRuntimeContext());
        if (parentNodeId.getPathPositions() == null) {
            LazyTreeSchemaBrowserPrefetchCommand cmd = new LazyTreeSchemaBrowserPrefetchCommand((IcCubeServerRequestContext)serverRequestContext, maxChildrenCount, serverQuery, engineUID, schemas, false);
            tree = (GwtSchemaBrowserTreeInfoModel)cmd.call();
        } else {
            LazyTreeSchemaBrowserCommand cmd = new LazyTreeSchemaBrowserCommand(serverRequestContext, maxChildrenCount, serverQuery, engineUID, schemas);
            tree = (GwtSchemaBrowserTreeInfoModel)cmd.call();
        }
        return new UxSchemaBrowsingTree(tree.isOutOfSync() ? UxLazyTreeStatus.OUT_OF_SYNC : null, tree.getServerTreeUId(), this.nodeId, UxBrowseSchemaQuery.asNodes(-1, tree.getNodeModels()));
    }

    public static List<UxSchemaBrowsingNode> asNodesForDimensionBrowsing(int moreParentPos, List<GwtSchemaBrowserTreeNodeModel> models) {
        return UxBrowseSchemaQuery.asNodes(false, moreParentPos, models);
    }

    public static List<UxSchemaBrowsingNode> asNodes(int moreParentPos, List<GwtSchemaBrowserTreeNodeModel> models) {
        return UxBrowseSchemaQuery.asNodes(true, moreParentPos, models);
    }

    private static List<UxSchemaBrowsingNode> asNodes(boolean withUniqueName, int moreParentPos, List<GwtSchemaBrowserTreeNodeModel> models) {
        ArrayList<UxSchemaBrowsingNode> nodes = new ArrayList<UxSchemaBrowsingNode>();
        if (models != null) {
            for (GwtSchemaBrowserTreeNodeModel model : models) {
                List<UxSchemaBrowsingNode> children;
                int[] positions;
                String caption = model.getName();
                Object mdxUniqueName = withUniqueName ? (CdStringUtils.isNotNullAndNotBlank((String)model.getMdxUniqueName()) ? model.getMdxUniqueName() : "[" + model.getName() + "]") : null;
                Object tooltip = CdStringUtils.isNotNullAndNotBlank((String)model.getTooltip()) ? model.getTooltip() : mdxUniqueName;
                UxSchemaBrowsingNodeType type = UxSchemaBrowsingNodeType.valueOf(model.getType());
                GwtLazyTreePathTreeNodeIdentifier nodeId = model.getNodeId();
                ArrayList<Integer> id = new ArrayList<Integer>();
                if (nodeId != null && (positions = nodeId.getPathPositions()) != null) {
                    for (int pp = 0; pp < positions.length; ++pp) {
                        int position = positions[pp];
                        id.add(position);
                    }
                }
                if (!model.hasLazyChildren()) {
                    List<GwtSchemaBrowserTreeNodeModel> modelChildren = model.getChildren();
                    children = UxBrowseSchemaQuery.asNodes(withUniqueName, -1, modelChildren);
                } else {
                    children = null;
                }
                nodes.add(new UxSchemaBrowsingNode(type, id, caption, (String)tooltip, (String)mdxUniqueName, children));
            }
        }
        return nodes;
    }
}

