/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.gvi;

import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authorization.permissions.role.OlapRolePermissions;
import crazydev.iccube.olap.component.OlapEngineComponent;
import crazydev.iccube.olap.component.context.OlapEngineRequestContext;
import crazydev.iccube.olap.component.naming.OlapNameContext;
import crazydev.iccube.olap.component.naming.OlapRequestNamesContext;
import crazydev.iccube.olap.cube.OlapCube;
import crazydev.iccube.olap.entity.permissions.IOlapSchemaPermission;
import crazydev.iccube.olap.entity.permissions.IOlapSchemasPermission;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletion;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletionContextInfo;
import crazydev.iccube.olap.goodies.codecompletion.OlapCodeCompletionCubeContextInfo;
import crazydev.iccube.olap.schema.OlapSchema;
import crazydev.iccube.request.log.OlapRequestId;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQuery;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.mdx.queries.completion.result.UxMdxCompletion;
import crazydev.iccube.ux.mdx.queries.completion.result.UxMdxSuggestion;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class UxReportingMdxCompletionQuery
extends UxQuery {
    private final int maxCount;
    private final String mdx;
    private final int offset;
    @Nullable
    private final String schemaName;
    @Nullable
    private final String cubeName;

    protected UxReportingMdxCompletionQuery(UxQueryMeta meta, OlapRequestId requestId, int maxCount, String mdx, int offset, @Nullable String schemaName, @Nullable String cubeName) {
        super(meta, requestId);
        this.maxCount = maxCount;
        this.mdx = mdx;
        this.offset = offset;
        this.schemaName = CdStringUtils.isNullOrBlank((String)schemaName) ? null : schemaName;
        this.cubeName = CdStringUtils.isNullOrBlank((String)cubeName) ? null : cubeName;
    }

    @Override
    @Nullable
    public String getSchemaName() {
        return this.schemaName;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return this.schemaName != null ? IcCubeSchemaAccessLockMode.READ : IcCubeSchemaAccessLockMode.NONE;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        OlapEngineRequestContext engineRequestContext = queryContext.getOlapEngineRequestContext();
        OlapRequestNamesContext nameContext = engineRequestContext.getNameContext();
        OlapCodeCompletionContextInfo contextInfo = this.setupContextInfo(engineRequestContext);
        List options = OlapCodeCompletion.getSuggestions((OlapRolePermissions)engineRequestContext.getCurrentPermissions(), (OlapRequestNamesContext)nameContext, (int)this.maxCount, (OlapCodeCompletionContextInfo)contextInfo, (String)this.mdx, (int)this.offset);
        List<UxMdxSuggestion> suggestions = options.stream().map(option -> new UxMdxSuggestion(option.getCompletion(), option.getCaption())).collect(Collectors.toList());
        return UxReply.actionSuccess(new UxMdxCompletion(suggestions));
    }

    private OlapCodeCompletionContextInfo setupContextInfo(OlapEngineRequestContext engineRequestContext) {
        OlapCube cube;
        OlapSchema schema;
        if (this.schemaName != null) {
            OlapEngineComponent olapEngine = engineRequestContext.getOlapEngineComponent();
            schema = olapEngine.getAuthorizedSchema(engineRequestContext, IcCubeSchemaAccessLockMode.READ, this.schemaName);
            if (schema != null) {
                IOlapSchemasPermission schemasPermissions = engineRequestContext.getSchemasPermissions();
                IOlapSchemaPermission schemaPermissions = schemasPermissions.getSchemaPermissions(engineRequestContext, schema, true);
                cube = schema.lookupCubeByName(schemaPermissions, (OlapNameContext)engineRequestContext.getNameContext(), this.cubeName);
            } else {
                cube = null;
            }
        } else {
            schema = null;
            cube = null;
        }
        return new OlapCodeCompletionCubeContextInfo(engineRequestContext, schema, cube);
    }
}

