/*
 * Decompiled with CFR 0.152.
 */
package crazydev.iccube.ux.console.queries.upload;

import crazydev.common.babylon.CdBabylonService;
import crazydev.common.exception.CdError;
import crazydev.common.fs.CdVFileSystem;
import crazydev.common.utils.CdStringUtils;
import crazydev.iccube.authentication.definition.OlapUserDefinition;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionError;
import crazydev.iccube.authorization.errors.OlapRoleDefinitionErrorCode;
import crazydev.iccube.authorization.permissions.common.OlapRoleAuthorizationException;
import crazydev.iccube.builder.offline.common.OlapBuilderOfflineHelper;
import crazydev.iccube.cluster.master.backup.save.M_BackupManager;
import crazydev.iccube.directories.OlapDirectoriesResolved;
import crazydev.iccube.fs.OlapFile;
import crazydev.iccube.fs.OlapFileSystem;
import crazydev.iccube.olap.component.schemas.OlapEngineSchemaDefFactoryHelper;
import crazydev.iccube.olap.loggers.OlapLoggers;
import crazydev.iccube.pub.authentication.IOlapAuthenticationService;
import crazydev.iccube.request.task.IcCubeSchemaAccessLockMode;
import crazydev.iccube.server.scheduler.errors.IcCubeSchedulerDefinitionErrorException;
import crazydev.iccube.server.scheduler.runtime.IcCubeScheduler;
import crazydev.iccube.server.scheduler.runtime.IcCubeSchedulerKind;
import crazydev.iccube.ux.admin.queries.alerts.UxAlertsQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsDeleteQueryMeta;
import crazydev.iccube.ux.admin.queries.docs.UxDocsHelper;
import crazydev.iccube.ux.admin.queries.reporting.UxReportingHelper;
import crazydev.iccube.ux.admin.queries.reporting.UxReportingQueryMeta;
import crazydev.iccube.ux.admin.queries.roles.UxRolesException;
import crazydev.iccube.ux.admin.queries.roles.UxRolesHelper;
import crazydev.iccube.ux.admin.queries.roles.UxRolesQueryMeta;
import crazydev.iccube.ux.admin.queries.scheduler.UxSchemasScheduleQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.UxSchemaFactoryFile;
import crazydev.iccube.ux.admin.queries.schema.UxUnloadedSchemasQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.backup.UxBackupsQueryMeta;
import crazydev.iccube.ux.admin.queries.schema.offline.UxOfflinesQueryMeta;
import crazydev.iccube.ux.admin.queries.users.UxUsersException;
import crazydev.iccube.ux.admin.queries.users.UxUsersHelper;
import crazydev.iccube.ux.admin.queries.users.UxUsersQueryMeta;
import crazydev.iccube.ux.builder.common.UxSchemaId;
import crazydev.iccube.ux.builder.queries.init.UxSchemaBuilderHomeQueryMeta;
import crazydev.iccube.ux.builder.queries.schema.UxSchemaDefsQueryMeta;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaInfo;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaService;
import crazydev.iccube.ux.builder.service.UxBuilderSchemaServiceException;
import crazydev.iccube.ux.builder.usecase.UxBuilderUseCaseName;
import crazydev.iccube.ux.common.meta.UxQueryMeta;
import crazydev.iccube.ux.common.query.UxQueryContext;
import crazydev.iccube.ux.common.reply.UxErrorCode;
import crazydev.iccube.ux.common.reply.UxFileUploadReply;
import crazydev.iccube.ux.common.reply.UxReply;
import crazydev.iccube.ux.common.usecase.UxUseCase;
import crazydev.iccube.ux.common.usecase.UxUseCaseBuilder;
import crazydev.iccube.ux.common.validation.UxValidationResult;
import crazydev.iccube.ux.console.UxConsoleQuery;
import crazydev.iccube.ux.console.queries.profile.UxUserProfileQueryMeta;
import crazydev.iccube.ux.console.queries.upload.UxFileType;
import crazydev.iccube.ux.processor.UxBabylonService;
import crazydev.iccube.ux.processor.UxServerRequestParams;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.eclipse.jetty.util.IO;
import org.jetbrains.annotations.Nullable;

public class UxUploadFileQuery
extends UxConsoleQuery {
    private final UxServerRequestParams params;
    private final UxFileType fileType;
    @Nullable
    private final String fileName;

    protected UxUploadFileQuery(UxQueryMeta meta, UxServerRequestParams params, UxFileType fileType, @Nullable String fileName) {
        super(meta, params.getRequestId());
        this.params = params;
        this.fileType = fileType;
        this.fileName = fileName;
    }

    @Override
    public boolean isForAllSchemas() {
        return this.fileType == UxFileType.ROLES;
    }

    @Override
    public IcCubeSchemaAccessLockMode getSchemaAccessLockMode() {
        return this.fileType == UxFileType.ROLES ? IcCubeSchemaAccessLockMode.WRITE : IcCubeSchemaAccessLockMode.NONE;
    }

    @Override
    protected UxReply executeQuery(UxQueryContext queryContext) {
        UxBabylonService babylon = queryContext.getUxBabylonService();
        if (this.fileName == null || CdStringUtils.isNullOrBlank((String)this.fileName)) {
            return UxFileUploadReply.error("missing fileName parameter");
        }
        try {
            switch (this.fileType) {
                case ALERTS_SCHEDULE: {
                    UxAlertsQueryMeta.Alerts.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForScheduler(queryContext, this.params, this.fileName, IcCubeSchedulerKind.ALERTS);
                }
                case DOCS: {
                    UxDocsDeleteQueryMeta.DocsDelete.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForDocsUpload(queryContext, this.params, this.fileName);
                }
                case DASHBOARDS: {
                    UxReportingQueryMeta.Reporting.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForDashboardsInstall(queryContext, this.params, this.fileName);
                }
                case ROLES: {
                    UxRolesQueryMeta.Roles.assertAuthorized(queryContext);
                    if (queryContext.canEditOwnsRole(null)) {
                        throw new OlapRoleAuthorizationException(new OlapRoleDefinitionError(OlapRoleDefinitionErrorCode.QUERY_NOT_AUTHORIZED, new Serializable[]{UxRolesQueryMeta.Roles.queryName().name()}));
                    }
                    return UxUploadFileQuery.executeForRoles(queryContext, this.params, this.fileName);
                }
                case SCHEMAS_SCHEDULE: {
                    UxSchemasScheduleQueryMeta.SchemasSchedule.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForScheduler(queryContext, this.params, this.fileName, IcCubeSchedulerKind.SCHEMAS);
                }
                case SCHEMA_BACKUP: {
                    UxBackupsQueryMeta.Backups.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForSchemaBackup(queryContext, this.params, this.fileName);
                }
                case SCHEMA_DEF: {
                    UxSchemaDefsQueryMeta.SchemaDefs.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForSchemaDefinition(queryContext, this.params, this.fileName);
                }
                case SCHEMA_DEF_DEPLOYED: {
                    UxUnloadedSchemasQueryMeta.UnloadedSchemas.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForDeployedSchemaDefinition(queryContext, this.params, this.fileName);
                }
                case SCHEMA_OFFLINE: {
                    UxOfflinesQueryMeta.Offlines.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForSchemaOffline(queryContext, this.params, this.fileName);
                }
                case USER_PROFILE_PHOTO: {
                    UxUserProfileQueryMeta.UserProfile.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForUserProfile(queryContext, this.params, this.fileName);
                }
                case USERS: {
                    UxUsersQueryMeta.Users.assertAuthorized(queryContext);
                    return UxUploadFileQuery.executeForUsers(queryContext, this.params, this.fileName);
                }
            }
            return UxFileUploadReply.error(babylon.translate("invalidFileType", new Serializable[]{this.fileType}));
        }
        catch (OlapRoleAuthorizationException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] upload file authorization error", (Throwable)ex);
            return UxFileUploadReply.error(ex.getError().asMessage((CdBabylonService)queryContext.getOlapBabylonService()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UxFileUploadReply executeForDeployedSchemaDefinition(UxQueryContext context, UxServerRequestParams params, String fileName) {
        if (!fileName.endsWith(".icc-schema")) {
            return UxFileUploadReply.error("file extension mismatch (expected: *.icc-schema)");
        }
        UxBabylonService babylon = context.getUxBabylonService();
        OlapDirectoriesResolved resolvedDirectories = context.getResolvedDirectories();
        OlapFileSystem cubes = OlapFileSystem.createFileSystem((CdVFileSystem)resolvedDirectories.getVfs(), (File)resolvedDirectories.getCubesDirectory());
        OlapFile dest = cubes.create(fileName);
        File dest_ = dest.__getUnderlying();
        if (dest.exists()) {
            return UxFileUploadReply.error("file exists");
        }
        OlapLoggers.UX_REQUEST.info((Object)("[UX] uploading schema definition [" + fileName + "] to : " + dest_.getAbsolutePath()));
        InputStream in = null;
        try {
            in = params.getInputStream();
            OlapEngineSchemaDefFactoryHelper helper = context.getDeployedSchemaDefFactoryHelper();
            String savedBy = context.getUserName();
            String operation = "uploaded";
            helper.writeSchemaDefFactoryFileContent(savedBy, dest_, in, "uploaded");
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] schema definition file [ " + fileName + " ] deployment error"), (Throwable)ex);
            String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.error(message);
            return uxFileUploadReply;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return UxFileUploadReply.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UxFileUploadReply executeForScheduler(UxQueryContext context, UxServerRequestParams params, String fileName, IcCubeSchedulerKind schedulerKind) {
        if (!fileName.endsWith(IcCubeSchedulerKind.fileExtensionX())) {
            return UxFileUploadReply.error("file extension mismatch (expected: *." + IcCubeSchedulerKind.fileExtension() + ")");
        }
        UxBabylonService babylon = context.getUxBabylonService();
        InputStream in = null;
        try {
            in = params.getInputStream();
            IcCubeScheduler scheduler = context.getScheduler(schedulerKind);
            scheduler.importAndScheduleDefinitionX(context.asRuntimeContext(), null, in);
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.success();
            return uxFileUploadReply;
        }
        catch (IcCubeSchedulerDefinitionErrorException | IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] " + schedulerKind.nameLC() + " deployment error"), (Throwable)ex);
            String message = babylon.translate("uploadFileError", new Serializable[]{((Throwable)ex).getLocalizedMessage()});
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.error(message);
            return uxFileUploadReply;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static UxFileUploadReply executeForSchemaBackup(UxQueryContext context, UxServerRequestParams params, String fileName) {
        if (!fileName.endsWith(".zip")) {
            return UxFileUploadReply.error("file extension mismatch (expected: *.zip)");
        }
        UxBabylonService babylon = context.getUxBabylonService();
        try {
            M_BackupManager backupManager = context.getBackupManager();
            fileName = fileName.substring(0, fileName.lastIndexOf(46));
            backupManager.importBackup(fileName, params::getInputStream);
            return UxFileUploadReply.success();
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] schema backup [ " + fileName + " ] deployment error"), (Throwable)ex);
            String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
            return UxFileUploadReply.error(message);
        }
    }

    private static UxFileUploadReply executeForSchemaOffline(UxQueryContext context, UxServerRequestParams params, String fileName) {
        String destDirectoryName;
        File snapshots;
        if (!fileName.endsWith(".zip")) {
            return UxFileUploadReply.error("file extension mismatch (expected: *.zip)");
        }
        if (!OlapBuilderOfflineHelper.isValid((String)fileName)) {
            return UxFileUploadReply.error("file name invalid");
        }
        OlapDirectoriesResolved directories = context.getResolvedDirectories();
        CdVFileSystem vfs = directories.getVfs();
        OlapFileSystem fs = OlapFileSystem.createFileSystem((CdVFileSystem)vfs, (File)(snapshots = directories.getOfflineDirectory()));
        OlapFile destDirectory = fs.create(destDirectoryName = fileName.substring(0, fileName.lastIndexOf(46)));
        if (destDirectory.exists()) {
            return UxFileUploadReply.error("existing schema snapshot [" + fileName + "] (delete first the existing snapshot)");
        }
        UxBabylonService babylon = context.getUxBabylonService();
        try {
            vfs.uploadZip(destDirectory.__getUnderlying(), params::getInputStream);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] schema snapshot [ " + fileName + "] upload error"), (Throwable)ex);
            String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
            return UxFileUploadReply.error(message);
        }
        return UxFileUploadReply.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UxFileUploadReply executeForUsers(UxQueryContext context, UxServerRequestParams params, String fileName) {
        UxFileUploadReply uxFileUploadReply;
        if (!fileName.endsWith(".icc-users")) {
            return UxFileUploadReply.error("file extension mismatch (expected: *.icc-users)");
        }
        UxBabylonService babylon = context.getUxBabylonService();
        InputStream in = null;
        try {
            in = params.getInputStream();
            UxUsersHelper.applyUserDefinitions(context, in, "uploaded");
            uxFileUploadReply = UxFileUploadReply.success();
        }
        catch (UxUsersException | IOException ex) {
            UxFileUploadReply uxFileUploadReply2;
            try {
                OlapLoggers.UX_REQUEST.error((Object)"[UX] users deployment error", (Throwable)ex);
                String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
                uxFileUploadReply2 = UxFileUploadReply.error(message);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return uxFileUploadReply2;
        }
        IOUtils.closeQuietly((InputStream)in);
        return uxFileUploadReply;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UxFileUploadReply executeForUserProfile(UxQueryContext context, UxServerRequestParams params, String fileName) {
        UxValidationResult error;
        String photoBase64;
        if (!fileName.endsWith(".png")) {
            return UxFileUploadReply.error("file extension mismatch (expected: *.png)");
        }
        UxBabylonService babylon = context.getUxBabylonService();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            in = params.getInputStream();
            IO.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] user's photo copy error", (Throwable)ex);
            String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.error(message);
            return uxFileUploadReply;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        try {
            byte[] content = out.toByteArray();
            UxUploadFileQuery.assertImageFormat(content);
            photoBase64 = Base64.encodeBase64String((byte[])content);
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)"[UX] user's photo format error", (Throwable)ex);
            String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
            return UxFileUploadReply.error(message);
        }
        IOlapAuthenticationService service = context.getAuthenticationService();
        String userUUID = params.getStringParameter("userUUID");
        if (CdStringUtils.isNullOrBlank((String)userUUID)) {
            String userName = context.getUserName();
            OlapUserDefinition user = service.getUserDefinitionByName(userName);
            if (user == null) {
                return UxFileUploadReply.error(UxErrorCode.USER_PROFILE_MISSING.asMessage(babylon, new Serializable[0]));
            }
            userUUID = user.getUUID();
        }
        if ((error = UxUsersHelper.saveUserPhoto(context, userUUID, photoBase64)) != null) {
            return UxFileUploadReply.error(error);
        }
        return UxFileUploadReply.success();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UxFileUploadReply executeForRoles(UxQueryContext context, UxServerRequestParams params, String fileName) {
        UxFileUploadReply uxFileUploadReply;
        if (!fileName.endsWith(".icc-roles")) {
            return UxFileUploadReply.error("file extension mismatch (expected: *.icc-roles)");
        }
        UxBabylonService babylon = context.getUxBabylonService();
        InputStream in = null;
        try {
            in = params.getInputStream();
            UxRolesHelper.applyRoleDefinitions(context, in, "uploaded");
            uxFileUploadReply = UxFileUploadReply.success();
        }
        catch (UxRolesException | IOException ex) {
            UxFileUploadReply uxFileUploadReply2;
            try {
                OlapLoggers.UX_REQUEST.error((Object)"[UX] roles deployment error", (Throwable)ex);
                String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
                uxFileUploadReply2 = UxFileUploadReply.error(message);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            return uxFileUploadReply2;
        }
        IOUtils.closeQuietly((InputStream)in);
        return uxFileUploadReply;
    }

    private static UxFileUploadReply executeForDocsUpload(UxQueryContext context, UxServerRequestParams params, String fileName) {
        return UxDocsHelper.upload(context, params, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static UxFileUploadReply executeForDashboardsInstall(UxQueryContext context, UxServerRequestParams params, String fileName) {
        InputStream in = null;
        try {
            in = params.getInputStream();
            UxFileUploadReply uxFileUploadReply = UxReportingHelper.installDashboards(context, params, fileName, in);
            return uxFileUploadReply;
        }
        catch (IOException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] upload file [" + fileName + "] error"), (Throwable)ex);
            UxBabylonService babylon = context.getUxBabylonService();
            String message = babylon.translate("uploadFileError", new Serializable[]{ex.getLocalizedMessage()});
            UxFileUploadReply uxFileUploadReply = UxFileUploadReply.error(message);
            return uxFileUploadReply;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private static UxFileUploadReply executeForSchemaDefinition(UxQueryContext context, UxServerRequestParams params, String fileName) {
        if (!fileName.endsWith("icc-schema")) {
            return UxFileUploadReply.error("file extension mismatch (expected: *.icc-schema)");
        }
        UxBuilderSchemaService service = context.getPersistentSchemaService();
        try {
            UxBuilderSchemaInfo uploadedSchemaInfo = service.saveSchemaDefForUpload(context.getUserName(), fileName, params);
            String schemaName = uploadedSchemaInfo.getSchemaName();
            UxSchemaFactoryFile factoryFile = UxSchemaFactoryFile.fromFile(context, true, uploadedSchemaInfo.getFactoryFile());
            UxSchemaId schemaId = new UxSchemaId(schemaName, factoryFile.relativePath());
            UxUseCase useCase = new UxUseCaseBuilder(context, UxSchemaBuilderHomeQueryMeta.BuilderHomeS, schemaId).withId(UxBuilderUseCaseName.BuilderHomeS).build(false);
            return UxFileUploadReply.success(useCase);
        }
        catch (UxBuilderSchemaServiceException ex) {
            OlapLoggers.UX_REQUEST.error((Object)("[UX] schema definition file [ " + fileName + " ] deployment error"), (Throwable)ex);
            CdError error = ex.error();
            String errorMessage = error.asMessage((CdBabylonService)context.getOlapBabylonService());
            UxBabylonService babylon = context.getUxBabylonService();
            String message = babylon.translate("uploadFileError", new Serializable[]{errorMessage});
            return UxFileUploadReply.error(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertImageFormat(byte[] content) throws IOException {
        ImageInputStream stream = ImageIO.createImageInputStream(new ByteArrayInputStream(content));
        Iterator<ImageReader> readers = ImageIO.getImageReaders(stream);
        if (!readers.hasNext()) {
            throw new IOException("image format not supported (expecting a PNG image)");
        }
        ImageReader reader = readers.next();
        ImageReadParam param = reader.getDefaultReadParam();
        reader.setInput(stream, true, true);
        try {
            BufferedImage bi = reader.read(0, param);
            String format = reader.getFormatName();
            if (!"png".equalsIgnoreCase(format)) {
                throw new IOException("image format [" + format + "] not supported (expecting a PNG image)");
            }
            int height = bi.getHeight();
            int width = bi.getWidth();
            if (height != 40 && width != 40) {
                throw new IOException("image size [" + height + "x" + width + "] not supported (expecting 40x40)");
            }
        }
        finally {
            reader.dispose();
            stream.close();
        }
    }
}

